/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.LockSafety;
import com.highmobility.autoapi.value.LockState;
import com.highmobility.autoapi.value.Position;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class Trunk {
    public static final int IDENTIFIER = 33;
    public static final byte PROPERTY_LOCK = 1;
    public static final byte PROPERTY_POSITION = 2;
    public static final byte PROPERTY_LOCK_SAFETY = 3;

    public static class State
    extends SetCommand {
        Property<LockState> lock = new Property<LockState>(LockState.class, 1);
        Property<Position> position = new Property<Position>(Position.class, 2);
        Property<LockSafety> lockSafety = new Property<LockSafety>(LockSafety.class, 3);

        public Property<LockState> getLock() {
            return this.lock;
        }

        public Property<Position> getPosition() {
            return this.position;
        }

        public Property<LockSafety> getLockSafety() {
            return this.lockSafety;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.lock.update(p);
                        }
                        case 2: {
                            return this.position.update(p);
                        }
                        case 3: {
                            return this.lockSafety.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(33);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setLock(Property<LockState> lock) {
                Property<LockState> property = lock.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setPosition(Property<Position> position) {
                Property<Position> property = position.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setLockSafety(Property<LockSafety> lockSafety) {
                Property<LockSafety> property = lockSafety.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ControlTrunk
    extends SetCommand {
        Property<LockState> lock = new Property<LockState>(LockState.class, 1);
        Property<Position> position = new Property<Position>(Position.class, 2);

        public Property<LockState> getLock() {
            return this.lock;
        }

        public Property<Position> getPosition() {
            return this.position;
        }

        public ControlTrunk(@Nullable LockState lock, @Nullable Position position) {
            super(33);
            this.addProperty(this.lock.update(lock));
            this.addProperty(this.position.update(position));
            if (this.lock.getValue() == null && this.position.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlTrunk(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.lock.update(p);
                        }
                        case 2: {
                            return this.position.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.lock.getValue() == null && this.position.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)33, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)33, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 33);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)33, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)33, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(33);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(33, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(33, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

