/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.AccelerationDuration;
import com.highmobility.autoapi.value.DistanceOverTime;
import com.highmobility.autoapi.value.DrivingMode;
import com.highmobility.autoapi.value.DrivingModeActivationPeriod;
import com.highmobility.autoapi.value.DrivingModeEnergyConsumption;
import com.highmobility.autoapi.value.Grade;
import com.highmobility.autoapi.value.TripMeter;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.Energy;
import com.highmobility.autoapi.value.measurement.EnergyEfficiency;
import com.highmobility.autoapi.value.measurement.FuelEfficiency;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.autoapi.value.measurement.Power;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.autoapi.value.measurement.Volume;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nullable;

public class Usage {
    public static final int IDENTIFIER = 104;
    public static final byte PROPERTY_AVERAGE_WEEKLY_DISTANCE = 1;
    public static final byte PROPERTY_AVERAGE_WEEKLY_DISTANCE_LONG_RUN = 2;
    public static final byte PROPERTY_ACCELERATION_EVALUATION = 3;
    public static final byte PROPERTY_DRIVING_STYLE_EVALUATION = 4;
    public static final byte PROPERTY_DRIVING_MODES_ACTIVATION_PERIODS = 5;
    public static final byte PROPERTY_DRIVING_MODES_ENERGY_CONSUMPTIONS = 6;
    public static final byte PROPERTY_LAST_TRIP_ENERGY_CONSUMPTION = 7;
    public static final byte PROPERTY_LAST_TRIP_FUEL_CONSUMPTION = 8;
    public static final byte PROPERTY_MILEAGE_AFTER_LAST_TRIP = 9;
    public static final byte PROPERTY_LAST_TRIP_ELECTRIC_PORTION = 10;
    public static final byte PROPERTY_LAST_TRIP_AVERAGE_ENERGY_RECUPERATION = 11;
    public static final byte PROPERTY_LAST_TRIP_BATTERY_REMAINING = 12;
    public static final byte PROPERTY_LAST_TRIP_DATE = 13;
    public static final byte PROPERTY_AVERAGE_FUEL_CONSUMPTION = 14;
    public static final byte PROPERTY_CURRENT_FUEL_CONSUMPTION = 15;
    public static final byte PROPERTY_ODOMETER_AFTER_LAST_TRIP = 16;
    public static final byte PROPERTY_SAFETY_DRIVING_SCORE = 17;
    public static final byte PROPERTY_RAPID_ACCELERATION_GRADE = 18;
    public static final byte PROPERTY_RAPID_DECELERATION_GRADE = 19;
    public static final byte PROPERTY_LATE_NIGHT_GRADE = 20;
    public static final byte PROPERTY_DISTANCE_OVER_TIME = 21;
    public static final byte PROPERTY_ELECTRIC_CONSUMPTION_RATE_SINCE_START = 22;
    public static final byte PROPERTY_ELECTRIC_CONSUMPTION_RATE_SINCE_RESET = 23;
    public static final byte PROPERTY_ELECTRIC_DISTANCE_LAST_TRIP = 24;
    public static final byte PROPERTY_ELECTRIC_DISTANCE_SINCE_RESET = 25;
    public static final byte PROPERTY_ELECTRIC_DURATION_LAST_TRIP = 26;
    public static final byte PROPERTY_ELECTRIC_DURATION_SINCE_RESET = 27;
    public static final byte PROPERTY_FUEL_CONSUMPTION_RATE_LAST_TRIP = 28;
    public static final byte PROPERTY_FUEL_CONSUMPTION_RATE_SINCE_RESET = 29;
    public static final byte PROPERTY_AVERAGE_SPEED_LAST_TRIP = 30;
    public static final byte PROPERTY_AVERAGE_SPEED_SINCE_RESET = 31;
    public static final byte PROPERTY_FUEL_DISTANCE_LAST_TRIP = 32;
    public static final byte PROPERTY_FUEL_DISTANCE_SINCE_RESET = 33;
    public static final byte PROPERTY_DRIVING_DURATION_LAST_TRIP = 34;
    public static final byte PROPERTY_DRIVING_DURATION_SINCE_RESET = 35;
    public static final byte PROPERTY_ECO_SCORE_TOTAL = 36;
    public static final byte PROPERTY_ECO_SCORE_FREE_WHEEL = 37;
    public static final byte PROPERTY_ECO_SCORE_CONSTANT = 38;
    public static final byte PROPERTY_ECO_SCORE_BONUS_RANGE = 39;
    public static final byte PROPERTY_TRIP_METERS = 40;
    public static final byte PROPERTY_ELECTRIC_CONSUMPTION_AVERAGE = 41;
    public static final byte PROPERTY_BRAKING_EVALUATION = 42;
    public static final byte PROPERTY_AVERAGE_SPEED = 43;
    public static final byte PROPERTY_RECUPERATION_POWER = 44;
    public static final byte PROPERTY_ACCELERATION_DURATIONS = 45;

    public static class State
    extends SetCommand {
        Property<Length> averageWeeklyDistance = new Property<Length>(Length.class, 1);
        Property<Length> averageWeeklyDistanceLongRun = new Property<Length>(Length.class, 2);
        Property<Double> accelerationEvaluation = new Property<Double>(Double.class, 3);
        Property<Double> drivingStyleEvaluation = new Property<Double>(Double.class, 4);
        List<Property<DrivingModeActivationPeriod>> drivingModesActivationPeriods;
        List<Property<DrivingModeEnergyConsumption>> drivingModesEnergyConsumptions;
        Property<Energy> lastTripEnergyConsumption = new Property<Energy>(Energy.class, 7);
        Property<Volume> lastTripFuelConsumption = new Property<Volume>(Volume.class, 8);
        Property<Length> mileageAfterLastTrip = new Property<Length>(Length.class, 9);
        Property<Double> lastTripElectricPortion = new Property<Double>(Double.class, 10);
        Property<EnergyEfficiency> lastTripAverageEnergyRecuperation = new Property<EnergyEfficiency>(EnergyEfficiency.class, 11);
        Property<Double> lastTripBatteryRemaining = new Property<Double>(Double.class, 12);
        Property<Calendar> lastTripDate = new Property<Calendar>(Calendar.class, 13);
        Property<FuelEfficiency> averageFuelConsumption = new Property<FuelEfficiency>(FuelEfficiency.class, 14);
        Property<FuelEfficiency> currentFuelConsumption = new Property<FuelEfficiency>(FuelEfficiency.class, 15);
        Property<Length> odometerAfterLastTrip = new Property<Length>(Length.class, 16);
        Property<Double> safetyDrivingScore = new Property<Double>(Double.class, 17);
        Property<Grade> rapidAccelerationGrade = new Property<Grade>(Grade.class, 18);
        Property<Grade> rapidDecelerationGrade = new Property<Grade>(Grade.class, 19);
        Property<Grade> lateNightGrade = new Property<Grade>(Grade.class, 20);
        Property<DistanceOverTime> distanceOverTime = new Property<DistanceOverTime>(DistanceOverTime.class, 21);
        Property<EnergyEfficiency> electricConsumptionRateSinceStart = new Property<EnergyEfficiency>(EnergyEfficiency.class, 22);
        Property<EnergyEfficiency> electricConsumptionRateSinceReset = new Property<EnergyEfficiency>(EnergyEfficiency.class, 23);
        Property<Length> electricDistanceLastTrip = new Property<Length>(Length.class, 24);
        Property<Length> electricDistanceSinceReset = new Property<Length>(Length.class, 25);
        Property<Duration> electricDurationLastTrip = new Property<Duration>(Duration.class, 26);
        Property<Duration> electricDurationSinceReset = new Property<Duration>(Duration.class, 27);
        Property<FuelEfficiency> fuelConsumptionRateLastTrip = new Property<FuelEfficiency>(FuelEfficiency.class, 28);
        Property<FuelEfficiency> fuelConsumptionRateSinceReset = new Property<FuelEfficiency>(FuelEfficiency.class, 29);
        Property<Speed> averageSpeedLastTrip = new Property<Speed>(Speed.class, 30);
        Property<Speed> averageSpeedSinceReset = new Property<Speed>(Speed.class, 31);
        Property<Length> fuelDistanceLastTrip = new Property<Length>(Length.class, 32);
        Property<Length> fuelDistanceSinceReset = new Property<Length>(Length.class, 33);
        Property<Duration> drivingDurationLastTrip = new Property<Duration>(Duration.class, 34);
        Property<Duration> drivingDurationSinceReset = new Property<Duration>(Duration.class, 35);
        Property<Double> ecoScoreTotal = new Property<Double>(Double.class, 36);
        Property<Double> ecoScoreFreeWheel = new Property<Double>(Double.class, 37);
        Property<Double> ecoScoreConstant = new Property<Double>(Double.class, 38);
        Property<Length> ecoScoreBonusRange = new Property<Length>(Length.class, 39);
        List<Property<TripMeter>> tripMeters;
        Property<EnergyEfficiency> electricConsumptionAverage = new Property<EnergyEfficiency>(EnergyEfficiency.class, 41);
        Property<Double> brakingEvaluation = new Property<Double>(Double.class, 42);
        Property<Speed> averageSpeed = new Property<Speed>(Speed.class, 43);
        Property<Power> recuperationPower = new Property<Power>(Power.class, 44);
        List<Property<AccelerationDuration>> accelerationDurations;

        public Property<Length> getAverageWeeklyDistance() {
            return this.averageWeeklyDistance;
        }

        public Property<Length> getAverageWeeklyDistanceLongRun() {
            return this.averageWeeklyDistanceLongRun;
        }

        public Property<Double> getAccelerationEvaluation() {
            return this.accelerationEvaluation;
        }

        public Property<Double> getDrivingStyleEvaluation() {
            return this.drivingStyleEvaluation;
        }

        public List<Property<DrivingModeActivationPeriod>> getDrivingModesActivationPeriods() {
            return this.drivingModesActivationPeriods;
        }

        public List<Property<DrivingModeEnergyConsumption>> getDrivingModesEnergyConsumptions() {
            return this.drivingModesEnergyConsumptions;
        }

        public Property<Energy> getLastTripEnergyConsumption() {
            return this.lastTripEnergyConsumption;
        }

        public Property<Volume> getLastTripFuelConsumption() {
            return this.lastTripFuelConsumption;
        }

        @Deprecated
        public Property<Length> getMileageAfterLastTrip() {
            return this.mileageAfterLastTrip;
        }

        public Property<Double> getLastTripElectricPortion() {
            return this.lastTripElectricPortion;
        }

        public Property<EnergyEfficiency> getLastTripAverageEnergyRecuperation() {
            return this.lastTripAverageEnergyRecuperation;
        }

        public Property<Double> getLastTripBatteryRemaining() {
            return this.lastTripBatteryRemaining;
        }

        public Property<Calendar> getLastTripDate() {
            return this.lastTripDate;
        }

        public Property<FuelEfficiency> getAverageFuelConsumption() {
            return this.averageFuelConsumption;
        }

        public Property<FuelEfficiency> getCurrentFuelConsumption() {
            return this.currentFuelConsumption;
        }

        public Property<Length> getOdometerAfterLastTrip() {
            return this.odometerAfterLastTrip;
        }

        public Property<Double> getSafetyDrivingScore() {
            return this.safetyDrivingScore;
        }

        public Property<Grade> getRapidAccelerationGrade() {
            return this.rapidAccelerationGrade;
        }

        public Property<Grade> getRapidDecelerationGrade() {
            return this.rapidDecelerationGrade;
        }

        public Property<Grade> getLateNightGrade() {
            return this.lateNightGrade;
        }

        public Property<DistanceOverTime> getDistanceOverTime() {
            return this.distanceOverTime;
        }

        public Property<EnergyEfficiency> getElectricConsumptionRateSinceStart() {
            return this.electricConsumptionRateSinceStart;
        }

        public Property<EnergyEfficiency> getElectricConsumptionRateSinceReset() {
            return this.electricConsumptionRateSinceReset;
        }

        public Property<Length> getElectricDistanceLastTrip() {
            return this.electricDistanceLastTrip;
        }

        public Property<Length> getElectricDistanceSinceReset() {
            return this.electricDistanceSinceReset;
        }

        public Property<Duration> getElectricDurationLastTrip() {
            return this.electricDurationLastTrip;
        }

        public Property<Duration> getElectricDurationSinceReset() {
            return this.electricDurationSinceReset;
        }

        public Property<FuelEfficiency> getFuelConsumptionRateLastTrip() {
            return this.fuelConsumptionRateLastTrip;
        }

        public Property<FuelEfficiency> getFuelConsumptionRateSinceReset() {
            return this.fuelConsumptionRateSinceReset;
        }

        public Property<Speed> getAverageSpeedLastTrip() {
            return this.averageSpeedLastTrip;
        }

        public Property<Speed> getAverageSpeedSinceReset() {
            return this.averageSpeedSinceReset;
        }

        public Property<Length> getFuelDistanceLastTrip() {
            return this.fuelDistanceLastTrip;
        }

        public Property<Length> getFuelDistanceSinceReset() {
            return this.fuelDistanceSinceReset;
        }

        public Property<Duration> getDrivingDurationLastTrip() {
            return this.drivingDurationLastTrip;
        }

        public Property<Duration> getDrivingDurationSinceReset() {
            return this.drivingDurationSinceReset;
        }

        public Property<Double> getEcoScoreTotal() {
            return this.ecoScoreTotal;
        }

        public Property<Double> getEcoScoreFreeWheel() {
            return this.ecoScoreFreeWheel;
        }

        public Property<Double> getEcoScoreConstant() {
            return this.ecoScoreConstant;
        }

        public Property<Length> getEcoScoreBonusRange() {
            return this.ecoScoreBonusRange;
        }

        public List<Property<TripMeter>> getTripMeters() {
            return this.tripMeters;
        }

        public Property<EnergyEfficiency> getElectricConsumptionAverage() {
            return this.electricConsumptionAverage;
        }

        public Property<Double> getBrakingEvaluation() {
            return this.brakingEvaluation;
        }

        public Property<Speed> getAverageSpeed() {
            return this.averageSpeed;
        }

        public Property<Power> getRecuperationPower() {
            return this.recuperationPower;
        }

        public List<Property<AccelerationDuration>> getAccelerationDurations() {
            return this.accelerationDurations;
        }

        @Nullable
        public Property<DrivingModeActivationPeriod> getDrivingModeActivationPeriod(DrivingMode mode) {
            for (Property<DrivingModeActivationPeriod> drivingModeActivationPeriod : this.drivingModesActivationPeriods) {
                if (drivingModeActivationPeriod.getValue() == null || drivingModeActivationPeriod.getValue().getDrivingMode() != mode) continue;
                return drivingModeActivationPeriod;
            }
            return null;
        }

        @Nullable
        public Property<DrivingModeEnergyConsumption> getDrivingModeEnergyConsumption(DrivingMode mode) {
            for (Property<DrivingModeEnergyConsumption> drivingModeEnergyConsumption : this.drivingModesEnergyConsumptions) {
                if (drivingModeEnergyConsumption.getValue() == null || drivingModeEnergyConsumption.getValue().getDrivingMode() != mode) continue;
                return drivingModeEnergyConsumption;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<DrivingModeActivationPeriod>> drivingModesActivationPeriodsBuilder = new ArrayList<Property<DrivingModeActivationPeriod>>();
            ArrayList<Property<DrivingModeEnergyConsumption>> drivingModesEnergyConsumptionsBuilder = new ArrayList<Property<DrivingModeEnergyConsumption>>();
            ArrayList<Property<TripMeter>> tripMetersBuilder = new ArrayList<Property<TripMeter>>();
            ArrayList<Property<AccelerationDuration>> accelerationDurationsBuilder = new ArrayList<Property<AccelerationDuration>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.averageWeeklyDistance.update(p);
                        }
                        case 2: {
                            return this.averageWeeklyDistanceLongRun.update(p);
                        }
                        case 3: {
                            return this.accelerationEvaluation.update(p);
                        }
                        case 4: {
                            return this.drivingStyleEvaluation.update(p);
                        }
                        case 5: {
                            Property<DrivingModeActivationPeriod> drivingModesActivationPeriod = new Property<DrivingModeActivationPeriod>(DrivingModeActivationPeriod.class, p);
                            drivingModesActivationPeriodsBuilder.add(drivingModesActivationPeriod);
                            return drivingModesActivationPeriod;
                        }
                        case 6: {
                            Property<DrivingModeEnergyConsumption> drivingModeEnergyConsumption = new Property<DrivingModeEnergyConsumption>(DrivingModeEnergyConsumption.class, p);
                            drivingModesEnergyConsumptionsBuilder.add(drivingModeEnergyConsumption);
                            return drivingModeEnergyConsumption;
                        }
                        case 7: {
                            return this.lastTripEnergyConsumption.update(p);
                        }
                        case 8: {
                            return this.lastTripFuelConsumption.update(p);
                        }
                        case 9: {
                            return this.mileageAfterLastTrip.update(p);
                        }
                        case 10: {
                            return this.lastTripElectricPortion.update(p);
                        }
                        case 11: {
                            return this.lastTripAverageEnergyRecuperation.update(p);
                        }
                        case 12: {
                            return this.lastTripBatteryRemaining.update(p);
                        }
                        case 13: {
                            return this.lastTripDate.update(p);
                        }
                        case 14: {
                            return this.averageFuelConsumption.update(p);
                        }
                        case 15: {
                            return this.currentFuelConsumption.update(p);
                        }
                        case 16: {
                            return this.odometerAfterLastTrip.update(p);
                        }
                        case 17: {
                            return this.safetyDrivingScore.update(p);
                        }
                        case 18: {
                            return this.rapidAccelerationGrade.update(p);
                        }
                        case 19: {
                            return this.rapidDecelerationGrade.update(p);
                        }
                        case 20: {
                            return this.lateNightGrade.update(p);
                        }
                        case 21: {
                            return this.distanceOverTime.update(p);
                        }
                        case 22: {
                            return this.electricConsumptionRateSinceStart.update(p);
                        }
                        case 23: {
                            return this.electricConsumptionRateSinceReset.update(p);
                        }
                        case 24: {
                            return this.electricDistanceLastTrip.update(p);
                        }
                        case 25: {
                            return this.electricDistanceSinceReset.update(p);
                        }
                        case 26: {
                            return this.electricDurationLastTrip.update(p);
                        }
                        case 27: {
                            return this.electricDurationSinceReset.update(p);
                        }
                        case 28: {
                            return this.fuelConsumptionRateLastTrip.update(p);
                        }
                        case 29: {
                            return this.fuelConsumptionRateSinceReset.update(p);
                        }
                        case 30: {
                            return this.averageSpeedLastTrip.update(p);
                        }
                        case 31: {
                            return this.averageSpeedSinceReset.update(p);
                        }
                        case 32: {
                            return this.fuelDistanceLastTrip.update(p);
                        }
                        case 33: {
                            return this.fuelDistanceSinceReset.update(p);
                        }
                        case 34: {
                            return this.drivingDurationLastTrip.update(p);
                        }
                        case 35: {
                            return this.drivingDurationSinceReset.update(p);
                        }
                        case 36: {
                            return this.ecoScoreTotal.update(p);
                        }
                        case 37: {
                            return this.ecoScoreFreeWheel.update(p);
                        }
                        case 38: {
                            return this.ecoScoreConstant.update(p);
                        }
                        case 39: {
                            return this.ecoScoreBonusRange.update(p);
                        }
                        case 40: {
                            Property<TripMeter> tripMeter = new Property<TripMeter>(TripMeter.class, p);
                            tripMetersBuilder.add(tripMeter);
                            return tripMeter;
                        }
                        case 41: {
                            return this.electricConsumptionAverage.update(p);
                        }
                        case 42: {
                            return this.brakingEvaluation.update(p);
                        }
                        case 43: {
                            return this.averageSpeed.update(p);
                        }
                        case 44: {
                            return this.recuperationPower.update(p);
                        }
                        case 45: {
                            Property<AccelerationDuration> accelerationDuration = new Property<AccelerationDuration>(AccelerationDuration.class, p);
                            accelerationDurationsBuilder.add(accelerationDuration);
                            return accelerationDuration;
                        }
                    }
                    return null;
                });
            }
            this.drivingModesActivationPeriods = drivingModesActivationPeriodsBuilder;
            this.drivingModesEnergyConsumptions = drivingModesEnergyConsumptionsBuilder;
            this.tripMeters = tripMetersBuilder;
            this.accelerationDurations = accelerationDurationsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(104);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setAverageWeeklyDistance(Property<Length> averageWeeklyDistance) {
                Property<Length> property = averageWeeklyDistance.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageWeeklyDistanceLongRun(Property<Length> averageWeeklyDistanceLongRun) {
                Property<Length> property = averageWeeklyDistanceLongRun.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setAccelerationEvaluation(Property<Double> accelerationEvaluation) {
                Property<Double> property = accelerationEvaluation.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivingStyleEvaluation(Property<Double> drivingStyleEvaluation) {
                Property<Double> property = drivingStyleEvaluation.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivingModesActivationPeriods(Property<DrivingModeActivationPeriod>[] drivingModesActivationPeriods) {
                for (int i = 0; i < drivingModesActivationPeriods.length; ++i) {
                    this.addDrivingModesActivationPeriod(drivingModesActivationPeriods[i]);
                }
                return this;
            }

            public Builder addDrivingModesActivationPeriod(Property<DrivingModeActivationPeriod> drivingModesActivationPeriod) {
                drivingModesActivationPeriod.setIdentifier((byte)5);
                this.addProperty(drivingModesActivationPeriod);
                return this;
            }

            public Builder setDrivingModesEnergyConsumptions(Property<DrivingModeEnergyConsumption>[] drivingModesEnergyConsumptions) {
                for (int i = 0; i < drivingModesEnergyConsumptions.length; ++i) {
                    this.addDrivingModeEnergyConsumption(drivingModesEnergyConsumptions[i]);
                }
                return this;
            }

            public Builder addDrivingModeEnergyConsumption(Property<DrivingModeEnergyConsumption> drivingModeEnergyConsumption) {
                drivingModeEnergyConsumption.setIdentifier((byte)6);
                this.addProperty(drivingModeEnergyConsumption);
                return this;
            }

            public Builder setLastTripEnergyConsumption(Property<Energy> lastTripEnergyConsumption) {
                Property<Energy> property = lastTripEnergyConsumption.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setLastTripFuelConsumption(Property<Volume> lastTripFuelConsumption) {
                Property<Volume> property = lastTripFuelConsumption.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setMileageAfterLastTrip(Property<Length> mileageAfterLastTrip) {
                Property<Length> property = mileageAfterLastTrip.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setLastTripElectricPortion(Property<Double> lastTripElectricPortion) {
                Property<Double> property = lastTripElectricPortion.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setLastTripAverageEnergyRecuperation(Property<EnergyEfficiency> lastTripAverageEnergyRecuperation) {
                Property<EnergyEfficiency> property = lastTripAverageEnergyRecuperation.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setLastTripBatteryRemaining(Property<Double> lastTripBatteryRemaining) {
                Property<Double> property = lastTripBatteryRemaining.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setLastTripDate(Property<Calendar> lastTripDate) {
                Property<Calendar> property = lastTripDate.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageFuelConsumption(Property<FuelEfficiency> averageFuelConsumption) {
                Property<FuelEfficiency> property = averageFuelConsumption.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setCurrentFuelConsumption(Property<FuelEfficiency> currentFuelConsumption) {
                Property<FuelEfficiency> property = currentFuelConsumption.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setOdometerAfterLastTrip(Property<Length> odometerAfterLastTrip) {
                Property<Length> property = odometerAfterLastTrip.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setSafetyDrivingScore(Property<Double> safetyDrivingScore) {
                Property<Double> property = safetyDrivingScore.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            public Builder setRapidAccelerationGrade(Property<Grade> rapidAccelerationGrade) {
                Property<Grade> property = rapidAccelerationGrade.setIdentifier((byte)18);
                this.addProperty(property);
                return this;
            }

            public Builder setRapidDecelerationGrade(Property<Grade> rapidDecelerationGrade) {
                Property<Grade> property = rapidDecelerationGrade.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setLateNightGrade(Property<Grade> lateNightGrade) {
                Property<Grade> property = lateNightGrade.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceOverTime(Property<DistanceOverTime> distanceOverTime) {
                Property<DistanceOverTime> property = distanceOverTime.setIdentifier((byte)21);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricConsumptionRateSinceStart(Property<EnergyEfficiency> electricConsumptionRateSinceStart) {
                Property<EnergyEfficiency> property = electricConsumptionRateSinceStart.setIdentifier((byte)22);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricConsumptionRateSinceReset(Property<EnergyEfficiency> electricConsumptionRateSinceReset) {
                Property<EnergyEfficiency> property = electricConsumptionRateSinceReset.setIdentifier((byte)23);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricDistanceLastTrip(Property<Length> electricDistanceLastTrip) {
                Property<Length> property = electricDistanceLastTrip.setIdentifier((byte)24);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricDistanceSinceReset(Property<Length> electricDistanceSinceReset) {
                Property<Length> property = electricDistanceSinceReset.setIdentifier((byte)25);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricDurationLastTrip(Property<Duration> electricDurationLastTrip) {
                Property<Duration> property = electricDurationLastTrip.setIdentifier((byte)26);
                this.addProperty(property);
                return this;
            }

            public Builder setElectricDurationSinceReset(Property<Duration> electricDurationSinceReset) {
                Property<Duration> property = electricDurationSinceReset.setIdentifier((byte)27);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelConsumptionRateLastTrip(Property<FuelEfficiency> fuelConsumptionRateLastTrip) {
                Property<FuelEfficiency> property = fuelConsumptionRateLastTrip.setIdentifier((byte)28);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelConsumptionRateSinceReset(Property<FuelEfficiency> fuelConsumptionRateSinceReset) {
                Property<FuelEfficiency> property = fuelConsumptionRateSinceReset.setIdentifier((byte)29);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageSpeedLastTrip(Property<Speed> averageSpeedLastTrip) {
                Property<Speed> property = averageSpeedLastTrip.setIdentifier((byte)30);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageSpeedSinceReset(Property<Speed> averageSpeedSinceReset) {
                Property<Speed> property = averageSpeedSinceReset.setIdentifier((byte)31);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelDistanceLastTrip(Property<Length> fuelDistanceLastTrip) {
                Property<Length> property = fuelDistanceLastTrip.setIdentifier((byte)32);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelDistanceSinceReset(Property<Length> fuelDistanceSinceReset) {
                Property<Length> property = fuelDistanceSinceReset.setIdentifier((byte)33);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivingDurationLastTrip(Property<Duration> drivingDurationLastTrip) {
                Property<Duration> property = drivingDurationLastTrip.setIdentifier((byte)34);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivingDurationSinceReset(Property<Duration> drivingDurationSinceReset) {
                Property<Duration> property = drivingDurationSinceReset.setIdentifier((byte)35);
                this.addProperty(property);
                return this;
            }

            public Builder setEcoScoreTotal(Property<Double> ecoScoreTotal) {
                Property<Double> property = ecoScoreTotal.setIdentifier((byte)36);
                this.addProperty(property);
                return this;
            }

            public Builder setEcoScoreFreeWheel(Property<Double> ecoScoreFreeWheel) {
                Property<Double> property = ecoScoreFreeWheel.setIdentifier((byte)37);
                this.addProperty(property);
                return this;
            }

            public Builder setEcoScoreConstant(Property<Double> ecoScoreConstant) {
                Property<Double> property = ecoScoreConstant.setIdentifier((byte)38);
                this.addProperty(property);
                return this;
            }

            public Builder setEcoScoreBonusRange(Property<Length> ecoScoreBonusRange) {
                Property<Length> property = ecoScoreBonusRange.setIdentifier((byte)39);
                this.addProperty(property);
                return this;
            }

            public Builder setTripMeters(Property<TripMeter>[] tripMeters) {
                for (int i = 0; i < tripMeters.length; ++i) {
                    this.addTripMeter(tripMeters[i]);
                }
                return this;
            }

            public Builder addTripMeter(Property<TripMeter> tripMeter) {
                tripMeter.setIdentifier((byte)40);
                this.addProperty(tripMeter);
                return this;
            }

            public Builder setElectricConsumptionAverage(Property<EnergyEfficiency> electricConsumptionAverage) {
                Property<EnergyEfficiency> property = electricConsumptionAverage.setIdentifier((byte)41);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakingEvaluation(Property<Double> brakingEvaluation) {
                Property<Double> property = brakingEvaluation.setIdentifier((byte)42);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageSpeed(Property<Speed> averageSpeed) {
                Property<Speed> property = averageSpeed.setIdentifier((byte)43);
                this.addProperty(property);
                return this;
            }

            public Builder setRecuperationPower(Property<Power> recuperationPower) {
                Property<Power> property = recuperationPower.setIdentifier((byte)44);
                this.addProperty(property);
                return this;
            }

            public Builder setAccelerationDurations(Property<AccelerationDuration>[] accelerationDurations) {
                for (int i = 0; i < accelerationDurations.length; ++i) {
                    this.addAccelerationDuration(accelerationDurations[i]);
                }
                return this;
            }

            public Builder addAccelerationDuration(Property<AccelerationDuration> accelerationDuration) {
                accelerationDuration.setIdentifier((byte)45);
                this.addProperty(accelerationDuration);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetUsageProperties
    extends GetCommand<State> {
        public GetUsageProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)104, propertyIdentifiers);
        }

        public GetUsageProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)104, new Bytes(propertyIdentifiers));
        }

        GetUsageProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetUsage
    extends GetCommand<State> {
        public GetUsage() {
            super(State.class, 104);
        }

        public GetUsage(Bytes propertyIdentifiers) {
            super(State.class, (Integer)104, propertyIdentifiers);
        }

        public GetUsage(byte ... propertyIdentifiers) {
            super(State.class, (Integer)104, new Bytes(propertyIdentifiers));
        }

        GetUsage(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetUsageAvailability
    extends GetAvailabilityCommand {
        public GetUsageAvailability() {
            super(104);
        }

        public GetUsageAvailability(Bytes propertyIdentifiers) {
            super(104, propertyIdentifiers);
        }

        public GetUsageAvailability(byte ... propertyIdentifiers) {
            super(104, new Bytes(propertyIdentifiers));
        }

        GetUsageAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

