/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;

public class ValetMode {
    public static final int IDENTIFIER = 40;
    public static final byte PROPERTY_STATUS = 1;

    public static class State
    extends SetCommand {
        Property<ActiveState> status = new Property<ActiveState>(ActiveState.class, 1);

        public Property<ActiveState> getStatus() {
            return this.status;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(40);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<ActiveState> status) {
                Property<ActiveState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ActivateDeactivateValetMode
    extends SetCommand {
        Property<ActiveState> status = new Property<ActiveState>(ActiveState.class, 1);

        public Property<ActiveState> getStatus() {
            return this.status;
        }

        public ActivateDeactivateValetMode(ActiveState status) {
            super(40);
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        ActivateDeactivateValetMode(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class GetValetMode
    extends GetCommand<State> {
        public GetValetMode() {
            super(State.class, 40);
        }

        GetValetMode(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetValetModeAvailability
    extends GetAvailabilityCommand {
        public GetValetModeAvailability() {
            super(40);
        }

        GetValetModeAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

