/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.Coordinates;
import com.highmobility.autoapi.value.measurement.Angle;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;

public class VehicleLocation {
    public static final int IDENTIFIER = 48;
    public static final byte PROPERTY_COORDINATES = 4;
    public static final byte PROPERTY_HEADING = 5;
    public static final byte PROPERTY_ALTITUDE = 6;
    public static final byte PROPERTY_PRECISION = 7;
    public static final byte PROPERTY_GPS_SOURCE = 8;
    public static final byte PROPERTY_GPS_SIGNAL_STRENGTH = 9;
    public static final byte PROPERTY_FUZZY_COORDINATES = 10;

    public static enum GpsSource implements ByteEnum
    {
        DEAD_RECKONING(0),
        REAL(1),
        NONE(2);

        private final byte value;

        public static GpsSource fromByte(byte byteValue) throws CommandParseException {
            GpsSource[] values = GpsSource.values();
            for (int i = 0; i < values.length; ++i) {
                GpsSource state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(GpsSource.class.getSimpleName(), byteValue));
        }

        private GpsSource(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Coordinates> coordinates = new Property<Coordinates>(Coordinates.class, 4);
        Property<Angle> heading = new Property<Angle>(Angle.class, 5);
        Property<Length> altitude = new Property<Length>(Length.class, 6);
        Property<Length> precision = new Property<Length>(Length.class, 7);
        Property<GpsSource> gpsSource = new Property<GpsSource>(GpsSource.class, 8);
        Property<Double> gpsSignalStrength = new Property<Double>(Double.class, 9);
        Property<Coordinates> fuzzyCoordinates = new Property<Coordinates>(Coordinates.class, 10);

        public Property<Coordinates> getCoordinates() {
            return this.coordinates;
        }

        public Property<Angle> getHeading() {
            return this.heading;
        }

        public Property<Length> getAltitude() {
            return this.altitude;
        }

        public Property<Length> getPrecision() {
            return this.precision;
        }

        public Property<GpsSource> getGpsSource() {
            return this.gpsSource;
        }

        public Property<Double> getGpsSignalStrength() {
            return this.gpsSignalStrength;
        }

        public Property<Coordinates> getFuzzyCoordinates() {
            return this.fuzzyCoordinates;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 4: {
                            return this.coordinates.update(p);
                        }
                        case 5: {
                            return this.heading.update(p);
                        }
                        case 6: {
                            return this.altitude.update(p);
                        }
                        case 7: {
                            return this.precision.update(p);
                        }
                        case 8: {
                            return this.gpsSource.update(p);
                        }
                        case 9: {
                            return this.gpsSignalStrength.update(p);
                        }
                        case 10: {
                            return this.fuzzyCoordinates.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(48);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setCoordinates(Property<Coordinates> coordinates) {
                Property<Coordinates> property = coordinates.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setHeading(Property<Angle> heading) {
                Property<Angle> property = heading.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setAltitude(Property<Length> altitude) {
                Property<Length> property = altitude.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setPrecision(Property<Length> precision) {
                Property<Length> property = precision.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setGpsSource(Property<GpsSource> gpsSource) {
                Property<GpsSource> property = gpsSource.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setGpsSignalStrength(Property<Double> gpsSignalStrength) {
                Property<Double> property = gpsSignalStrength.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setFuzzyCoordinates(Property<Coordinates> fuzzyCoordinates) {
                Property<Coordinates> property = fuzzyCoordinates.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetVehicleLocationProperties
    extends GetCommand<State> {
        public GetVehicleLocationProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)48, propertyIdentifiers);
        }

        public GetVehicleLocationProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)48, new Bytes(propertyIdentifiers));
        }

        GetVehicleLocationProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetVehicleLocation
    extends GetCommand<State> {
        public GetVehicleLocation() {
            super(State.class, 48);
        }

        public GetVehicleLocation(Bytes propertyIdentifiers) {
            super(State.class, (Integer)48, propertyIdentifiers);
        }

        public GetVehicleLocation(byte ... propertyIdentifiers) {
            super(State.class, (Integer)48, new Bytes(propertyIdentifiers));
        }

        GetVehicleLocation(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetVehicleLocationAvailability
    extends GetAvailabilityCommand {
        public GetVehicleLocationAvailability() {
            super(48);
        }

        public GetVehicleLocationAvailability(Bytes propertyIdentifiers) {
            super(48, propertyIdentifiers);
        }

        public GetVehicleLocationAvailability(byte ... propertyIdentifiers) {
            super(48, new Bytes(propertyIdentifiers));
        }

        GetVehicleLocationAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

