/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.capability.DisabledIn;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.value.Bytes;

public class WakeUp {
    public static final int IDENTIFIER = 34;
    public static final byte PROPERTY_STATUS = 1;
    public static final DisabledIn[] disabledIn = new DisabledIn[]{DisabledIn.BLE};

    public static enum Status implements ByteEnum
    {
        WAKE_UP(0),
        SLEEP(1);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class WakeUpCommand
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);

        public WakeUpCommand() {
            super(34);
            this.addProperty(this.status.addValueComponent(new Bytes("00")));
            this.createBytes();
        }

        WakeUpCommand(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null || !this.status.getValueComponent().getValueBytes().equals((Object)"00")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

