/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.Zone;
import com.highmobility.value.Bytes;
import java.util.Calendar;
import javax.annotation.Nullable;

public class Windscreen {
    public static final int IDENTIFIER = 66;
    public static final byte PROPERTY_WIPERS_STATUS = 1;
    public static final byte PROPERTY_WIPERS_INTENSITY = 2;
    public static final byte PROPERTY_WINDSCREEN_DAMAGE = 3;
    public static final byte PROPERTY_WINDSCREEN_ZONE_MATRIX = 4;
    public static final byte PROPERTY_WINDSCREEN_DAMAGE_ZONE = 5;
    public static final byte PROPERTY_WINDSCREEN_NEEDS_REPLACEMENT = 6;
    public static final byte PROPERTY_WINDSCREEN_DAMAGE_CONFIDENCE = 7;
    public static final byte PROPERTY_WINDSCREEN_DAMAGE_DETECTION_TIME = 8;

    public static enum WindscreenNeedsReplacement implements ByteEnum
    {
        UNKNOWN(0),
        NO_REPLACEMENT_NEEDED(1),
        REPLACEMENT_NEEDED(2);

        private final byte value;

        public static WindscreenNeedsReplacement fromByte(byte byteValue) throws CommandParseException {
            WindscreenNeedsReplacement[] values = WindscreenNeedsReplacement.values();
            for (int i = 0; i < values.length; ++i) {
                WindscreenNeedsReplacement state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(WindscreenNeedsReplacement.class.getSimpleName(), byteValue));
        }

        private WindscreenNeedsReplacement(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum WindscreenDamage implements ByteEnum
    {
        NO_IMPACT_DETECTED(0),
        IMPACT_BUT_NO_DAMAGE_DETECTED(1),
        DAMAGE_SMALLER_THAN_1_INCH(2),
        DAMAGE_LARGER_THAN_1_INCH(3);

        private final byte value;

        public static WindscreenDamage fromByte(byte byteValue) throws CommandParseException {
            WindscreenDamage[] values = WindscreenDamage.values();
            for (int i = 0; i < values.length; ++i) {
                WindscreenDamage state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(WindscreenDamage.class.getSimpleName(), byteValue));
        }

        private WindscreenDamage(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum WipersIntensity implements ByteEnum
    {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final byte value;

        public static WipersIntensity fromByte(byte byteValue) throws CommandParseException {
            WipersIntensity[] values = WipersIntensity.values();
            for (int i = 0; i < values.length; ++i) {
                WipersIntensity state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(WipersIntensity.class.getSimpleName(), byteValue));
        }

        private WipersIntensity(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum WipersStatus implements ByteEnum
    {
        INACTIVE(0),
        ACTIVE(1),
        AUTOMATIC(2);

        private final byte value;

        public static WipersStatus fromByte(byte byteValue) throws CommandParseException {
            WipersStatus[] values = WipersStatus.values();
            for (int i = 0; i < values.length; ++i) {
                WipersStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(WipersStatus.class.getSimpleName(), byteValue));
        }

        private WipersStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<WipersStatus> wipersStatus = new Property<WipersStatus>(WipersStatus.class, 1);
        Property<WipersIntensity> wipersIntensity = new Property<WipersIntensity>(WipersIntensity.class, 2);
        Property<WindscreenDamage> windscreenDamage = new Property<WindscreenDamage>(WindscreenDamage.class, 3);
        Property<Zone> windscreenZoneMatrix = new Property<Zone>(Zone.class, 4);
        Property<Zone> windscreenDamageZone = new Property<Zone>(Zone.class, 5);
        Property<WindscreenNeedsReplacement> windscreenNeedsReplacement = new Property<WindscreenNeedsReplacement>(WindscreenNeedsReplacement.class, 6);
        Property<Double> windscreenDamageConfidence = new Property<Double>(Double.class, 7);
        Property<Calendar> windscreenDamageDetectionTime = new Property<Calendar>(Calendar.class, 8);

        public Property<WipersStatus> getWipersStatus() {
            return this.wipersStatus;
        }

        public Property<WipersIntensity> getWipersIntensity() {
            return this.wipersIntensity;
        }

        public Property<WindscreenDamage> getWindscreenDamage() {
            return this.windscreenDamage;
        }

        public Property<Zone> getWindscreenZoneMatrix() {
            return this.windscreenZoneMatrix;
        }

        public Property<Zone> getWindscreenDamageZone() {
            return this.windscreenDamageZone;
        }

        public Property<WindscreenNeedsReplacement> getWindscreenNeedsReplacement() {
            return this.windscreenNeedsReplacement;
        }

        public Property<Double> getWindscreenDamageConfidence() {
            return this.windscreenDamageConfidence;
        }

        public Property<Calendar> getWindscreenDamageDetectionTime() {
            return this.windscreenDamageDetectionTime;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.wipersStatus.update(p);
                        }
                        case 2: {
                            return this.wipersIntensity.update(p);
                        }
                        case 3: {
                            return this.windscreenDamage.update(p);
                        }
                        case 4: {
                            return this.windscreenZoneMatrix.update(p);
                        }
                        case 5: {
                            return this.windscreenDamageZone.update(p);
                        }
                        case 6: {
                            return this.windscreenNeedsReplacement.update(p);
                        }
                        case 7: {
                            return this.windscreenDamageConfidence.update(p);
                        }
                        case 8: {
                            return this.windscreenDamageDetectionTime.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(66);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setWipersStatus(Property<WipersStatus> wipersStatus) {
                Property<WipersStatus> property = wipersStatus.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setWipersIntensity(Property<WipersIntensity> wipersIntensity) {
                Property<WipersIntensity> property = wipersIntensity.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenDamage(Property<WindscreenDamage> windscreenDamage) {
                Property<WindscreenDamage> property = windscreenDamage.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenZoneMatrix(Property<Zone> windscreenZoneMatrix) {
                Property<Zone> property = windscreenZoneMatrix.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenDamageZone(Property<Zone> windscreenDamageZone) {
                Property<Zone> property = windscreenDamageZone.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenNeedsReplacement(Property<WindscreenNeedsReplacement> windscreenNeedsReplacement) {
                Property<WindscreenNeedsReplacement> property = windscreenNeedsReplacement.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenDamageConfidence(Property<Double> windscreenDamageConfidence) {
                Property<Double> property = windscreenDamageConfidence.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setWindscreenDamageDetectionTime(Property<Calendar> windscreenDamageDetectionTime) {
                Property<Calendar> property = windscreenDamageDetectionTime.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ControlWipers
    extends SetCommand {
        Property<WipersStatus> wipersStatus = new Property<WipersStatus>(WipersStatus.class, 1);
        Property<WipersIntensity> wipersIntensity = new Property<WipersIntensity>(WipersIntensity.class, 2);

        public Property<WipersStatus> getWipersStatus() {
            return this.wipersStatus;
        }

        public Property<WipersIntensity> getWipersIntensity() {
            return this.wipersIntensity;
        }

        public ControlWipers(WipersStatus wipersStatus, @Nullable WipersIntensity wipersIntensity) {
            super(66);
            this.addProperty(this.wipersStatus.update(wipersStatus));
            this.addProperty(this.wipersIntensity.update(wipersIntensity));
            this.createBytes();
        }

        ControlWipers(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.wipersStatus.update(p);
                        }
                        case 2: {
                            return this.wipersIntensity.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.wipersStatus.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetWindscreenReplacementNeeded
    extends SetCommand {
        Property<WindscreenNeedsReplacement> windscreenNeedsReplacement = new Property<WindscreenNeedsReplacement>(WindscreenNeedsReplacement.class, 6);

        public Property<WindscreenNeedsReplacement> getWindscreenNeedsReplacement() {
            return this.windscreenNeedsReplacement;
        }

        public SetWindscreenReplacementNeeded(WindscreenNeedsReplacement windscreenNeedsReplacement) {
            super(66);
            this.addProperty(this.windscreenNeedsReplacement.update(windscreenNeedsReplacement));
            this.createBytes();
        }

        SetWindscreenReplacementNeeded(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 6) {
                        return this.windscreenNeedsReplacement.update(p);
                    }
                    return null;
                });
            }
            if (this.windscreenNeedsReplacement.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetWindscreenDamage
    extends SetCommand {
        Property<WindscreenDamage> windscreenDamage = new Property<WindscreenDamage>(WindscreenDamage.class, 3);
        Property<Zone> windscreenDamageZone = new Property<Zone>(Zone.class, 5);

        public Property<WindscreenDamage> getWindscreenDamage() {
            return this.windscreenDamage;
        }

        public Property<Zone> getWindscreenDamageZone() {
            return this.windscreenDamageZone;
        }

        public SetWindscreenDamage(WindscreenDamage windscreenDamage, @Nullable Zone windscreenDamageZone) {
            super(66);
            this.addProperty(this.windscreenDamage.update(windscreenDamage));
            this.addProperty(this.windscreenDamageZone.update(windscreenDamageZone));
            this.createBytes();
        }

        SetWindscreenDamage(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 3: {
                            return this.windscreenDamage.update(p);
                        }
                        case 5: {
                            return this.windscreenDamageZone.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.windscreenDamage.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)66, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)66, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 66);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)66, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)66, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(66);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(66, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(66, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

