/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.property;

import com.highmobility.autoapi.AutoApiLogger;
import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.exception.ParseException;
import com.highmobility.autoapi.property.PropertyComponent;
import com.highmobility.autoapi.property.PropertyComponentAvailability;
import com.highmobility.autoapi.property.PropertyComponentFailure;
import com.highmobility.autoapi.property.PropertyComponentTimestamp;
import com.highmobility.autoapi.property.PropertyComponentValue;
import com.highmobility.autoapi.value.Availability;
import com.highmobility.value.Bytes;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.Nullable;

public class Property<V>
extends Bytes {
    protected static final byte[] unknownBytes = new byte[]{0, 0, 0};
    @Nullable
    protected PropertyComponentValue<V> value;
    @Nullable
    protected PropertyComponentTimestamp timestamp;
    @Nullable
    protected PropertyComponentFailure failure;
    @Nullable
    protected PropertyComponentAvailability availability;
    protected List<PropertyComponent> components;
    private Class<V> valueClass = null;

    public byte getPropertyIdentifier() {
        return this.bytes[0];
    }

    @Nullable
    public V getValue() {
        return this.value != null ? (V)this.value.getValue() : null;
    }

    public List<PropertyComponent> getComponents() {
        return this.components;
    }

    @Nullable
    public PropertyComponent getComponent(byte identifier) {
        for (int i = 0; i < this.components.size(); ++i) {
            PropertyComponent component = this.components.get(i);
            if (component.getIdentifier() != identifier) continue;
            return component;
        }
        return null;
    }

    @Nullable
    public PropertyComponentValue getValueComponent() {
        return this.value;
    }

    @Nullable
    public Calendar getTimestamp() {
        if (this.timestamp == null) {
            return null;
        }
        return this.timestamp.getCalendar();
    }

    @Nullable
    PropertyComponentTimestamp getTimestampComponent() {
        return this.timestamp;
    }

    @Nullable
    public Availability getAvailability() {
        return this.availability.getAvailability();
    }

    @Nullable
    PropertyComponentAvailability getAvailabilityComponent() {
        return this.availability;
    }

    @Nullable
    public PropertyComponentFailure getFailureComponent() {
        return this.failure;
    }

    @Nullable
    Class<V> getValueClass() {
        return this.valueClass;
    }

    public int getPropertyLength() {
        return this.getLength() - 3;
    }

    public Property(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            bytes = unknownBytes;
        }
        if (bytes.length < 3) {
            bytes = Arrays.copyOf(bytes, 3);
        }
        this.bytes = bytes;
        this.findComponents();
    }

    protected void findComponents() {
        ArrayList<PropertyComponent> builder = new ArrayList<PropertyComponent>();
        for (int i = 3; i < this.bytes.length; ++i) {
            int size = Property.getUnsignedInt(this.bytes, i + 1, 2);
            byte componentIdentifier = this.bytes[i];
            Bytes componentBytes = this.getRange(i, i + 3 + size);
            try {
                switch (componentIdentifier) {
                    case 1: {
                        this.value = new PropertyComponentValue<V>(componentBytes, this.valueClass);
                        builder.add(this.value);
                        break;
                    }
                    case 2: {
                        this.timestamp = new PropertyComponentTimestamp(componentBytes);
                        builder.add(this.timestamp);
                        break;
                    }
                    case 3: {
                        this.failure = new PropertyComponentFailure(componentBytes);
                        builder.add(this.failure);
                        break;
                    }
                    case 5: {
                        this.availability = new PropertyComponentAvailability(componentBytes);
                        builder.add(this.availability);
                    }
                }
            }
            catch (Exception e) {
                builder.add(new PropertyComponent(componentBytes));
                this.printFailedToParse(e, componentBytes);
            }
            i += size + 2;
        }
        this.components = builder;
    }

    public Property(@Nullable V value) {
        this.update((byte)0, value, null, null, null);
    }

    public Property update(Property p) throws CommandParseException {
        if (this.valueClass == null) {
            throw new IllegalArgumentException("Initialise with a class to update.");
        }
        this.bytes = p.getByteArray();
        this.value = p.value;
        if (this.value != null) {
            try {
                this.value.setClass(this.valueClass);
            }
            catch (Exception e) {
                AutoApiLogger.getLogger().debug(String.format("Invalid bytes %s for property: %s\n%s", new Object[]{p, this.valueClass.getSimpleName(), e}));
            }
        }
        this.components = p.components;
        this.timestamp = p.timestamp;
        this.failure = p.failure;
        this.availability = p.availability;
        return this;
    }

    public Property(byte identifier, @Nullable V value, @Nullable Calendar timestamp, @Nullable PropertyComponentFailure failure, @Nullable PropertyComponentAvailability availability) {
        this.update(identifier, value, timestamp, failure, availability);
    }

    public Property(int identifier, V value) {
        this((byte)identifier, value);
    }

    public Property(byte identifier, V value) {
        this.update(identifier, value, null, null, null);
    }

    public Property(Class<V> valueClass, int identifier) {
        this(valueClass, (byte)identifier);
    }

    public Property(Class<V> valueClass, byte identifier) {
        this.bytes = new byte[]{identifier, 0, 0};
        this.valueClass = valueClass;
    }

    public Property(Class<V> valueClass, Property property) throws CommandParseException {
        this.valueClass = valueClass;
        if (property == null || property.getLength() == 0) {
            this.bytes = unknownBytes;
        }
        this.bytes = property.getLength() < 3 ? Arrays.copyOf(property.getByteArray(), 3) : property.getByteArray();
        this.update(property);
    }

    public Property update(V value) {
        return this.update(this.bytes[0], value, null, null, null);
    }

    public Property addValueComponent(Bytes valueComponentValue) {
        try {
            byte[] valueLength = Property.intToBytes(valueComponentValue.getLength(), 2);
            Bytes value = new Bytes(3 + valueComponentValue.getLength());
            value.set(0, (byte)1);
            value.set(1, valueLength);
            value.set(3, valueComponentValue);
            this.value = new PropertyComponentValue<V>(value, this.valueClass);
        }
        catch (CommandParseException e) {
            throw new IllegalArgumentException();
        }
        this.createBytesFromComponents(this.getPropertyIdentifier());
        return this;
    }

    private Property update(byte identifier, @Nullable V value, @Nullable Calendar timestamp, @Nullable PropertyComponentFailure failure, @Nullable PropertyComponentAvailability availability) {
        if (value != null && failure == null) {
            this.value = new PropertyComponentValue<V>(value);
        }
        if (timestamp != null) {
            this.timestamp = new PropertyComponentTimestamp(timestamp);
        }
        if (failure != null) {
            this.failure = failure;
        }
        if (availability != null) {
            this.availability = availability;
        }
        this.createBytesFromComponents(identifier);
        return this;
    }

    protected void createBytesFromComponents(byte propertyIdentifier) {
        int componentBytesLength = 0;
        int componentsSize = 0;
        if (this.value != null) {
            componentBytesLength += this.value.getLength();
            ++componentsSize;
        }
        if (this.timestamp != null) {
            componentBytesLength += this.timestamp.getLength();
            ++componentsSize;
        }
        if (this.failure != null) {
            componentBytesLength += this.failure.getLength();
            ++componentsSize;
        }
        if (this.availability != null) {
            componentBytesLength += this.availability.getLength();
            ++componentsSize;
        }
        ArrayList<PropertyComponent> componentsBuilder = new ArrayList<PropertyComponent>(componentsSize);
        Bytes builder = new Bytes(3 + componentBytesLength);
        builder.set(0, propertyIdentifier);
        builder.set(1, Property.intToBytes(componentBytesLength, 2));
        int pointer = 3;
        if (this.value != null) {
            builder.set(pointer, this.value);
            pointer += this.value.getLength();
            componentsBuilder.add(this.value);
        }
        if (this.timestamp != null) {
            builder.set(pointer, (Bytes)this.timestamp);
            pointer += this.timestamp.getLength();
            componentsBuilder.add(this.timestamp);
        }
        if (this.failure != null) {
            builder.set(pointer, (Bytes)this.failure);
            pointer += this.failure.getLength();
            componentsBuilder.add(this.failure);
        }
        if (this.availability != null) {
            builder.set(pointer, (Bytes)this.availability);
            componentsBuilder.add(this.availability);
        }
        this.bytes = builder.getByteArray();
        this.components = componentsBuilder;
    }

    public Property<V> setIdentifier(byte identifier) {
        this.bytes[0] = identifier;
        return this;
    }

    public Property<V> setIdentifier(int identifier) {
        this.setIdentifier((byte)identifier);
        return this;
    }

    public boolean isUniversalProperty() {
        return Command.universalPropertyIds.contains(this.getPropertyIdentifier());
    }

    public void printFailedToParse(Exception e, Bytes component) {
        String componentString = component != null ? " | Component " + component : "";
        String exceptionString = e != null ? " | " + e.getClass().getSimpleName() + ": " + e.getMessage() : "";
        AutoApiLogger.getLogger().warn(String.format("Failed to parse property: %s, %s, %s", this.toString(), componentString, exceptionString));
    }

    public static long getLong(byte[] b, int at) throws IllegalArgumentException {
        return Property.getLong(b, at, 8);
    }

    public static long getLong(byte[] b, int at, int length) throws IllegalArgumentException {
        if (b.length - at < length) {
            throw new IllegalArgumentException();
        }
        long result = 0L;
        for (int i = at; i < at + length; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static long getLong(byte[] b) throws IllegalArgumentException {
        return Property.getLong(b, 0, b.length);
    }

    public static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    public static float getFloat(Bytes bytes) throws IllegalArgumentException {
        return Property.getFloat(bytes.getByteArray());
    }

    public static float getFloat(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length < 4) {
            throw new IllegalArgumentException();
        }
        return Float.intBitsToFloat(Property.getUnsignedInt(bytes, 0, 4));
    }

    public static float getFloat(byte[] bytes, int at) throws IllegalArgumentException {
        int intValue = Property.getUnsignedInt(bytes, at, 4);
        return Float.intBitsToFloat(intValue);
    }

    public static float getFloat(Bytes bytes, int at) throws IllegalArgumentException {
        int intValue = Property.getUnsignedInt(bytes.getByteArray(), at, 4);
        return Float.intBitsToFloat(intValue);
    }

    public static byte[] floatToBytes(float value) {
        return ByteBuffer.allocate(4).putFloat(value).array();
    }

    public static double getDouble(Bytes bytes) throws IllegalArgumentException {
        return Property.getDouble(bytes.getByteArray());
    }

    public static double getDouble(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length < 8) {
            throw new IllegalArgumentException();
        }
        return Double.longBitsToDouble(Property.getLong(bytes));
    }

    public static double getDouble(byte[] bytes, int at) throws IllegalArgumentException {
        return Double.longBitsToDouble(Property.getLong(bytes, at));
    }

    public static double getDouble(Bytes bytes, int at) throws IllegalArgumentException {
        return Property.getDouble(bytes.getByteArray(), at);
    }

    public static byte[] doubleToBytes(double value) {
        long bits = Double.doubleToLongBits(value);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(bits);
        return buffer.array();
    }

    public static int floatToIntPercentage(float value) {
        return Math.round(value * 100.0f);
    }

    public static byte floatToIntPercentageByte(float value) {
        return (byte)Math.round(value * 100.0f);
    }

    public static float getPercentage(byte value) {
        return (float)Property.getUnsignedInt(value) / 100.0f;
    }

    public static int getUnsignedInt(byte value) {
        return value & 0xFF;
    }

    public static int getUnsignedInt(Bytes bytes) throws IllegalArgumentException {
        return Property.getUnsignedInt(bytes.getByteArray());
    }

    public static int getUnsignedInt(byte[] bytes) throws IllegalArgumentException {
        return Property.getUnsignedInt(bytes, 0, bytes.length);
    }

    public static int getUnsignedInt(Bytes bytes, int at, int length) throws IllegalArgumentException {
        return Property.getUnsignedInt(bytes.getByteArray(), at, length);
    }

    public static int getUnsignedInt(byte[] bytes, int at, int length) throws IllegalArgumentException {
        if (bytes.length >= at + length) {
            if (length == 4) {
                return (0xFF & bytes[at]) << 24 | (0xFF & bytes[at + 1]) << 16 | (0xFF & bytes[at + 2]) << 8 | 0xFF & bytes[at + 3];
            }
            if (length == 3) {
                return (bytes[at] & 0xFF) << 16 | (bytes[at + 1] & 0xFF) << 8 | bytes[at + 2] & 0xFF;
            }
            if (length == 2) {
                return (bytes[at] & 0xFF) << 8 | bytes[at + 1] & 0xFF;
            }
            if (length == 1) {
                return bytes[at] & 0xFF;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getSignedInt(byte value) {
        return value;
    }

    public static int getSignedInt(Bytes bytes) {
        return Property.getSignedInt(bytes.getByteArray());
    }

    public static int getSignedInt(byte[] bytes) {
        if (bytes.length == 1) {
            return Property.getSignedInt(bytes[0]);
        }
        if (bytes.length >= 2) {
            return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
        }
        throw new IllegalArgumentException();
    }

    public static int getSignedInt(byte[] bytes, int at, int length) {
        if (bytes.length >= 2) {
            return bytes[at] << 8 | bytes[at + 1];
        }
        throw new IllegalArgumentException();
    }

    public static byte[] intToBytes(int value, int length) throws IllegalArgumentException {
        if (length == 1) {
            return new byte[]{(byte)value};
        }
        byte[] bytes = BigInteger.valueOf(value).toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        if (bytes.length < length) {
            byte[] withZeroBytes = new byte[length];
            for (int i = 0; i < bytes.length; ++i) {
                withZeroBytes[length - 1 - i] = bytes[bytes.length - 1 - i];
            }
            return withZeroBytes;
        }
        throw new IllegalArgumentException();
    }

    public static Boolean getBool(byte value) {
        return value != 0;
    }

    public static byte boolToByte(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    public static byte getByte(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    public static String getString(Bytes bytes) {
        return Property.getString(bytes.getByteArray());
    }

    public static String getString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ParseException();
        }
    }

    public static String getString(Bytes bytes, int at, int length) {
        return Property.getString(bytes.getByteArray(), at, length);
    }

    public static String getString(byte[] bytes, int at, int length) {
        return Property.getString(Arrays.copyOfRange(bytes, at, at + length));
    }

    public static byte[] stringToBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ParseException();
        }
    }

    public static int getUtf8Length(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static Date getDate(byte[] bytes) throws IllegalArgumentException {
        for (int i = 0; i < bytes.length; ++i) {
            if (i == bytes.length - 1 && bytes[i] == 0) {
                return null;
            }
            if (bytes[i] != 0) break;
        }
        Calendar c = Calendar.getInstance();
        if (bytes.length == 5) {
            c.set(2000 + bytes[0], bytes[1] - 1, bytes[2], bytes[3], bytes[4], 0);
        } else if (bytes.length >= 6) {
            c.set(2000 + bytes[0], bytes[1] - 1, bytes[2], bytes[3], bytes[4], bytes[5]);
        } else {
            throw new IllegalArgumentException();
        }
        return c.getTime();
    }

    public static Calendar getCalendar(Property property) throws IllegalArgumentException {
        return Property.getCalendar(property.getValueComponent().getValueBytes());
    }

    public static Calendar getCalendar(Bytes bytes) throws IllegalArgumentException {
        return Property.getCalendar(bytes.getByteArray());
    }

    public static Calendar getCalendar(byte[] bytes) throws IllegalArgumentException {
        return Property.getCalendar(bytes, 0, bytes.length);
    }

    public static Calendar getCalendar(byte[] bytes, int at) throws IllegalArgumentException {
        return Property.getCalendar(bytes, at, 8);
    }

    public static Calendar getCalendar(byte[] bytes, int at, int length) throws IllegalArgumentException {
        if (bytes.length < at + length) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar c = new GregorianCalendar();
        long epoch = Property.getLong(bytes, at, length);
        c.setTimeInMillis(epoch);
        c.getTime();
        return c;
    }

    public static byte[] calendarToBytes(Calendar calendar) {
        return Property.longToBytes(calendar.getTimeInMillis());
    }

    public static int[] getIntegerArray(Bytes valueBytes) {
        int length = valueBytes.getLength();
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = Property.getUnsignedInt(valueBytes.get(i));
        }
        return value;
    }

    public static Bytes integerArrayToBytes(int[] value) {
        Bytes result = new Bytes(value.length);
        for (int i = 0; i < value.length; ++i) {
            byte byteValue = Property.intToBytes(value[i], 1)[0];
            result.set(i, byteValue);
        }
        return result;
    }
}

