/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.property;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyComponent;
import com.highmobility.autoapi.value.Failure;
import com.highmobility.utils.ByteUtils;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class PropertyComponentFailure
extends PropertyComponent {
    private static final byte IDENTIFIER = 3;
    Failure failure;

    public Failure getFailure() {
        return this.failure;
    }

    @Deprecated
    public Reason getFailureReason() throws CommandParseException {
        return Reason.fromByte(this.failure.getReason().getByte());
    }

    @Nullable
    public String getFailureDescription() {
        return this.failure.getDescription();
    }

    public PropertyComponentFailure(Bytes bytes) throws CommandParseException {
        super(bytes);
        this.failure = new Failure(this.getRange(3, this.size()));
    }

    public PropertyComponentFailure(Reason failureReason, @Nullable String description) throws CommandParseException {
        super((byte)3, 3 + description.length());
        this.bytes[3] = failureReason.getByte();
        if (description != null) {
            this.set(4, Property.intToBytes(description.length(), 2));
            ByteUtils.setBytes((byte[])this.bytes, (byte[])description.getBytes(), (int)6);
        }
        this.valueBytes = this.getRange(3, this.size());
        this.failure = new Failure(Failure.Reason.fromByte(failureReason.getByte()), description);
    }

    public PropertyComponentFailure(Failure failure) {
        super((byte)3, failure);
        this.failure = failure;
    }

    @Deprecated
    public static enum Reason {
        RATE_LIMIT(0),
        EXECUTION_TIMEOUT(1),
        FORMAT_ERROR(2),
        UNAUTHORISED(3),
        UNKNOWN(4),
        PENDING(5),
        INTERNAL_OEM_ERROR(6);

        private final byte value;

        public static Reason fromByte(byte byteValue) throws CommandParseException {
            Reason[] values = Reason.values();
            for (int i = 0; i < values.length; ++i) {
                Reason value1 = values[i];
                if (value1.getByte() != byteValue) continue;
                return value1;
            }
            throw new CommandParseException("Failure.Reason does not contain " + ByteUtils.hexFromByte((byte)byteValue));
        }

        private Reason(byte value) {
            this.value = value;
        }

        public byte getByte() {
            return this.value;
        }
    }
}

