/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Frequency;
import com.highmobility.value.Bytes;

public class Availability
extends PropertyValueObject {
    public static final int SIZE = 12;
    UpdateRate updateRate;
    Frequency rateLimit;
    AppliesPer appliesPer;

    public UpdateRate getUpdateRate() {
        return this.updateRate;
    }

    public Frequency getRateLimit() {
        return this.rateLimit;
    }

    public AppliesPer getAppliesPer() {
        return this.appliesPer;
    }

    public Availability(UpdateRate updateRate, Frequency rateLimit, AppliesPer appliesPer) {
        super(0);
        this.updateRate = updateRate;
        this.rateLimit = rateLimit;
        this.appliesPer = appliesPer;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, updateRate.getByte());
        this.set(++bytePosition, rateLimit);
        this.set(bytePosition += rateLimit.getLength(), appliesPer.getByte());
    }

    public Availability(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 12) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.updateRate = UpdateRate.fromByte(this.get(bytePosition));
        int rateLimitSize = 10;
        this.rateLimit = new Frequency(this.getRange(++bytePosition, bytePosition + rateLimitSize));
        this.appliesPer = AppliesPer.fromByte(this.get(bytePosition += rateLimitSize));
    }

    public int getLength() {
        return 12;
    }

    public static enum UpdateRate implements ByteEnum
    {
        TRIP_HIGH(0),
        TRIP(1),
        TRIP_START_END(2),
        TRIP_END(3),
        UNKNOWN(4),
        NOT_AVAILABLE(5),
        ON_CHANGE(6);

        private final byte value;

        public static UpdateRate fromByte(byte byteValue) throws CommandParseException {
            UpdateRate[] values = UpdateRate.values();
            for (int i = 0; i < values.length; ++i) {
                UpdateRate state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(UpdateRate.class.getSimpleName(), byteValue));
        }

        private UpdateRate(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum AppliesPer implements ByteEnum
    {
        APP(0),
        VEHICLE(1);

        private final byte value;

        public static AppliesPer fromByte(byte byteValue) throws CommandParseException {
            AppliesPer[] values = AppliesPer.values();
            for (int i = 0; i < values.length; ++i) {
                AppliesPer state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(AppliesPer.class.getSimpleName(), byteValue));
        }

        private AppliesPer(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

