/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ChargingCost
extends PropertyValueObject {
    String currency;
    Double calculatedChargingCost;
    Double calculatedSavings;
    Double simulatedImmediateChargingCost;

    public String getCurrency() {
        return this.currency;
    }

    public Double getCalculatedChargingCost() {
        return this.calculatedChargingCost;
    }

    public Double getCalculatedSavings() {
        return this.calculatedSavings;
    }

    public Double getSimulatedImmediateChargingCost() {
        return this.simulatedImmediateChargingCost;
    }

    public ChargingCost(String currency, Double calculatedChargingCost, Double calculatedSavings, Double simulatedImmediateChargingCost) {
        super(0);
        this.currency = currency;
        this.calculatedChargingCost = calculatedChargingCost;
        this.calculatedSavings = calculatedSavings;
        this.simulatedImmediateChargingCost = simulatedImmediateChargingCost;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(currency), 2));
        this.set(bytePosition += 2, Property.stringToBytes(currency));
        this.set(bytePosition += Property.getUtf8Length(currency), Property.doubleToBytes(calculatedChargingCost));
        this.set(bytePosition += 8, Property.doubleToBytes(calculatedSavings));
        this.set(bytePosition += 8, Property.doubleToBytes(simulatedImmediateChargingCost));
    }

    public ChargingCost(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 26) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int currencySize = this.getItemSize(bytePosition);
        this.currency = Property.getString(this.bytes, bytePosition += 2, currencySize);
        this.calculatedChargingCost = Property.getDouble(this.bytes, bytePosition += currencySize);
        this.calculatedSavings = Property.getDouble(this.bytes, bytePosition += 8);
        this.simulatedImmediateChargingCost = Property.getDouble(this.bytes, bytePosition += 8);
    }

    public int getLength() {
        return Property.getUtf8Length(this.currency) + 2 + 8 + 8 + 8;
    }
}

