/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ChargingLocation
extends PropertyValueObject {
    String municipality;
    String formattedAddress;
    String streetAddress;

    public String getMunicipality() {
        return this.municipality;
    }

    public String getFormattedAddress() {
        return this.formattedAddress;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public ChargingLocation(String municipality, String formattedAddress, String streetAddress) {
        super(0);
        this.municipality = municipality;
        this.formattedAddress = formattedAddress;
        this.streetAddress = streetAddress;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(municipality), 2));
        this.set(bytePosition += 2, Property.stringToBytes(municipality));
        this.set(bytePosition += Property.getUtf8Length(municipality), Property.intToBytes(Property.getUtf8Length(formattedAddress), 2));
        this.set(bytePosition += 2, Property.stringToBytes(formattedAddress));
        this.set(bytePosition += Property.getUtf8Length(formattedAddress), Property.intToBytes(Property.getUtf8Length(streetAddress), 2));
        this.set(bytePosition += 2, Property.stringToBytes(streetAddress));
    }

    public ChargingLocation(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 6) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int municipalitySize = this.getItemSize(bytePosition);
        this.municipality = Property.getString(this.bytes, bytePosition += 2, municipalitySize);
        int formattedAddressSize = this.getItemSize(bytePosition += municipalitySize);
        this.formattedAddress = Property.getString(this.bytes, bytePosition += 2, formattedAddressSize);
        int streetAddressSize = this.getItemSize(bytePosition += formattedAddressSize);
        this.streetAddress = Property.getString(this.bytes, bytePosition += 2, streetAddressSize);
    }

    public int getLength() {
        return Property.getUtf8Length(this.municipality) + 2 + Property.getUtf8Length(this.formattedAddress) + 2 + Property.getUtf8Length(this.streetAddress) + 2;
    }
}

