/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.value.Bytes;

public class ChargingRestriction
extends PropertyValueObject {
    public static final int SIZE = 2;
    ActiveState active;
    Limit limit;

    public ActiveState getActive() {
        return this.active;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public ChargingRestriction(ActiveState active, Limit limit) {
        super(0);
        this.active = active;
        this.limit = limit;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, active.getByte());
        this.set(++bytePosition, limit.getByte());
    }

    public ChargingRestriction(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.active = ActiveState.fromByte(this.get(bytePosition));
        this.limit = Limit.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Limit implements ByteEnum
    {
        MAX(0),
        REDUCED(1),
        MIN(2);

        private final byte value;

        public static Limit fromByte(byte byteValue) throws CommandParseException {
            Limit[] values = Limit.values();
            for (int i = 0; i < values.length; ++i) {
                Limit state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Limit.class.getSimpleName(), byteValue));
        }

        private Limit(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

