/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.value.Bytes;

public class CheckControlMessage
extends PropertyValueObject {
    Integer ID;
    Duration remainingTime;
    String text;
    String status;

    public Integer getID() {
        return this.ID;
    }

    public Duration getRemainingTime() {
        return this.remainingTime;
    }

    public String getText() {
        return this.text;
    }

    public String getStatus() {
        return this.status;
    }

    public CheckControlMessage(Integer ID, Duration remainingTime, String text, String status) {
        super(0);
        this.ID = ID;
        this.remainingTime = remainingTime;
        this.text = text;
        this.status = status;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(ID, 2));
        this.set(bytePosition += 2, remainingTime);
        this.set(bytePosition += remainingTime.getLength(), Property.intToBytes(Property.getUtf8Length(text), 2));
        this.set(bytePosition += 2, Property.stringToBytes(text));
        this.set(bytePosition += Property.getUtf8Length(text), Property.intToBytes(Property.getUtf8Length(status), 2));
        this.set(bytePosition += 2, Property.stringToBytes(status));
    }

    public CheckControlMessage(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 16) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.ID = Property.getUnsignedInt(this.bytes, bytePosition, 2);
        int remainingTimeSize = 10;
        this.remainingTime = new Duration(this.getRange(bytePosition += 2, bytePosition + remainingTimeSize));
        int textSize = this.getItemSize(bytePosition += remainingTimeSize);
        this.text = Property.getString(this.bytes, bytePosition += 2, textSize);
        int statusSize = this.getItemSize(bytePosition += textSize);
        this.status = Property.getString(this.bytes, bytePosition += 2, statusSize);
    }

    public int getLength() {
        return 12 + Property.getUtf8Length(this.text) + 2 + Property.getUtf8Length(this.status) + 2;
    }
}

