/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ConditionBasedService
extends PropertyValueObject {
    Integer year;
    Integer month;
    Integer id;
    DueStatus dueStatus;
    String text;
    String description;

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getId() {
        return this.id;
    }

    public DueStatus getDueStatus() {
        return this.dueStatus;
    }

    public String getText() {
        return this.text;
    }

    public String getDescription() {
        return this.description;
    }

    public ConditionBasedService(Integer year, Integer month, Integer id, DueStatus dueStatus, String text, String description) {
        super(0);
        this.year = year;
        this.month = month;
        this.id = id;
        this.dueStatus = dueStatus;
        this.text = text;
        this.description = description;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(year, 2));
        this.set(bytePosition += 2, Property.intToBytes(month, 1));
        this.set(++bytePosition, Property.intToBytes(id, 2));
        this.set(bytePosition += 2, dueStatus.getByte());
        this.set(++bytePosition, Property.intToBytes(Property.getUtf8Length(text), 2));
        this.set(bytePosition += 2, Property.stringToBytes(text));
        this.set(bytePosition += Property.getUtf8Length(text), Property.intToBytes(Property.getUtf8Length(description), 2));
        this.set(bytePosition += 2, Property.stringToBytes(description));
    }

    public ConditionBasedService(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 10) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.year = Property.getUnsignedInt(this.bytes, bytePosition, 2);
        this.month = Property.getUnsignedInt(this.bytes, bytePosition += 2, 1);
        this.id = Property.getUnsignedInt(this.bytes, ++bytePosition, 2);
        this.dueStatus = DueStatus.fromByte(this.get(bytePosition += 2));
        int textSize = this.getItemSize(++bytePosition);
        this.text = Property.getString(this.bytes, bytePosition += 2, textSize);
        int descriptionSize = this.getItemSize(bytePosition += textSize);
        this.description = Property.getString(this.bytes, bytePosition += 2, descriptionSize);
    }

    public int getLength() {
        return 6 + Property.getUtf8Length(this.text) + 2 + Property.getUtf8Length(this.description) + 2;
    }

    public static enum DueStatus implements ByteEnum
    {
        OK(0),
        PENDING(1),
        OVERDUE(2);

        private final byte value;

        public static DueStatus fromByte(byte byteValue) throws CommandParseException {
            DueStatus[] values = DueStatus.values();
            for (int i = 0; i < values.length; ++i) {
                DueStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DueStatus.class.getSimpleName(), byteValue));
        }

        private DueStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

