/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ConfirmedTroubleCode
extends PropertyValueObject {
    String ID;
    String ecuAddress;
    String ecuVariantName;
    String status;

    public String getID() {
        return this.ID;
    }

    public String getEcuAddress() {
        return this.ecuAddress;
    }

    public String getEcuVariantName() {
        return this.ecuVariantName;
    }

    public String getStatus() {
        return this.status;
    }

    public ConfirmedTroubleCode(String ID, String ecuAddress, String ecuVariantName, String status) {
        super(0);
        this.ID = ID;
        this.ecuAddress = ecuAddress;
        this.ecuVariantName = ecuVariantName;
        this.status = status;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(ID), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ID));
        this.set(bytePosition += Property.getUtf8Length(ID), Property.intToBytes(Property.getUtf8Length(ecuAddress), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ecuAddress));
        this.set(bytePosition += Property.getUtf8Length(ecuAddress), Property.intToBytes(Property.getUtf8Length(ecuVariantName), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ecuVariantName));
        this.set(bytePosition += Property.getUtf8Length(ecuVariantName), Property.intToBytes(Property.getUtf8Length(status), 2));
        this.set(bytePosition += 2, Property.stringToBytes(status));
    }

    public ConfirmedTroubleCode(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 8) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int IDSize = this.getItemSize(bytePosition);
        this.ID = Property.getString(this.bytes, bytePosition += 2, IDSize);
        int ecuAddressSize = this.getItemSize(bytePosition += IDSize);
        this.ecuAddress = Property.getString(this.bytes, bytePosition += 2, ecuAddressSize);
        int ecuVariantNameSize = this.getItemSize(bytePosition += ecuAddressSize);
        this.ecuVariantName = Property.getString(this.bytes, bytePosition += 2, ecuVariantNameSize);
        int statusSize = this.getItemSize(bytePosition += ecuVariantNameSize);
        this.status = Property.getString(this.bytes, bytePosition += 2, statusSize);
    }

    public int getLength() {
        return Property.getUtf8Length(this.ID) + 2 + Property.getUtf8Length(this.ecuAddress) + 2 + Property.getUtf8Length(this.ecuVariantName) + 2 + Property.getUtf8Length(this.status) + 2;
    }
}

