/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class CrashIncident
extends PropertyValueObject {
    public static final int SIZE = 3;
    Location location;
    Severity severity;
    Repairs repairs;

    public Location getLocation() {
        return this.location;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Repairs getRepairs() {
        return this.repairs;
    }

    public CrashIncident(Location location, Severity severity, Repairs repairs) {
        super(0);
        this.location = location;
        this.severity = severity;
        this.repairs = repairs;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, severity.getByte());
        this.set(++bytePosition, repairs.getByte());
    }

    public CrashIncident(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = Location.fromByte(this.get(bytePosition));
        this.severity = Severity.fromByte(this.get(++bytePosition));
        this.repairs = Repairs.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 3;
    }

    public static enum Location implements ByteEnum
    {
        FRONT(0),
        LATERAL(1),
        REAR(2);

        private final byte value;

        public static Location fromByte(byte byteValue) throws CommandParseException {
            Location[] values = Location.values();
            for (int i = 0; i < values.length; ++i) {
                Location state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Location.class.getSimpleName(), byteValue));
        }

        private Location(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Severity implements ByteEnum
    {
        VERY_HIGH(0),
        HIGH(1),
        MEDIUM(2),
        LOW(3),
        UNKNOWN(4);

        private final byte value;

        public static Severity fromByte(byte byteValue) throws CommandParseException {
            Severity[] values = Severity.values();
            for (int i = 0; i < values.length; ++i) {
                Severity state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Severity.class.getSimpleName(), byteValue));
        }

        private Severity(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Repairs implements ByteEnum
    {
        UNKNOWN(0),
        NEEDED(1),
        NOT_NEEDED(2);

        private final byte value;

        public static Repairs fromByte(byte byteValue) throws CommandParseException {
            Repairs[] values = Repairs.values();
            for (int i = 0; i < values.length; ++i) {
                Repairs state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Repairs.class.getSimpleName(), byteValue));
        }

        private Repairs(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

