/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class DieselExhaustFilterStatus
extends PropertyValueObject {
    public static final int SIZE = 3;
    Status status;
    Component component;
    Cleaning cleaning;

    public Status getStatus() {
        return this.status;
    }

    public Component getComponent() {
        return this.component;
    }

    public Cleaning getCleaning() {
        return this.cleaning;
    }

    public DieselExhaustFilterStatus(Status status, Component component, Cleaning cleaning) {
        super(0);
        this.status = status;
        this.component = component;
        this.cleaning = cleaning;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, status.getByte());
        this.set(++bytePosition, component.getByte());
        this.set(++bytePosition, cleaning.getByte());
    }

    public DieselExhaustFilterStatus(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.status = Status.fromByte(this.get(bytePosition));
        this.component = Component.fromByte(this.get(++bytePosition));
        this.cleaning = Cleaning.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 3;
    }

    public static enum Status implements ByteEnum
    {
        UNKNOWN(0),
        NORMAL_OPERATION(1),
        OVERLOADED(2),
        AT_LIMIT(3),
        OVER_LIMIT(4);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Component implements ByteEnum
    {
        UNKNOWN(0),
        EXHAUST_FILTER(1),
        DIESEL_PARTICULATE_FILTER(2),
        OVERBOOST_CODE_REGULATOR(3),
        OFF_BOARD_REGENERATION(4);

        private final byte value;

        public static Component fromByte(byte byteValue) throws CommandParseException {
            Component[] values = Component.values();
            for (int i = 0; i < values.length; ++i) {
                Component state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Component.class.getSimpleName(), byteValue));
        }

        private Component(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Cleaning implements ByteEnum
    {
        UNKNOWN(0),
        IN_PROGRESS(1),
        COMPLETE(2),
        INTERRUPTED(3);

        private final byte value;

        public static Cleaning fromByte(byte byteValue) throws CommandParseException {
            Cleaning[] values = Cleaning.values();
            for (int i = 0; i < values.length; ++i) {
                Cleaning state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Cleaning.class.getSimpleName(), byteValue));
        }

        private Cleaning(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

