/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.Position;
import com.highmobility.value.Bytes;

public class DoorPosition
extends PropertyValueObject {
    public static final int SIZE = 2;
    Location location;
    Position position;

    public Location getLocation() {
        return this.location;
    }

    public Position getPosition() {
        return this.position;
    }

    public DoorPosition(Location location, Position position) {
        super(0);
        this.location = location;
        this.position = position;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, position.getByte());
    }

    public DoorPosition(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = Location.fromByte(this.get(bytePosition));
        this.position = Position.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Location implements ByteEnum
    {
        FRONT_LEFT(0),
        FRONT_RIGHT(1),
        REAR_RIGHT(2),
        REAR_LEFT(3),
        ALL(5);

        private final byte value;

        public static Location fromByte(byte byteValue) throws CommandParseException {
            Location[] values = Location.values();
            for (int i = 0; i < values.length; ++i) {
                Location state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Location.class.getSimpleName(), byteValue));
        }

        private Location(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

