/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class DriverWorkingState
extends PropertyValueObject {
    public static final int SIZE = 2;
    Integer driverNumber;
    WorkingState workingState;

    public Integer getDriverNumber() {
        return this.driverNumber;
    }

    public WorkingState getWorkingState() {
        return this.workingState;
    }

    public DriverWorkingState(Integer driverNumber, WorkingState workingState) {
        super(0);
        this.driverNumber = driverNumber;
        this.workingState = workingState;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(driverNumber, 1));
        this.set(++bytePosition, workingState.getByte());
    }

    public DriverWorkingState(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.driverNumber = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.workingState = WorkingState.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum WorkingState implements ByteEnum
    {
        RESTING(0),
        DRIVER_AVAILABLE(1),
        WORKING(2),
        DRIVING(3);

        private final byte value;

        public static WorkingState fromByte(byte byteValue) throws CommandParseException {
            WorkingState[] values = WorkingState.values();
            for (int i = 0; i < values.length; ++i) {
                WorkingState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(WorkingState.class.getSimpleName(), byteValue));
        }

        private WorkingState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

