/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.DrivingMode;
import com.highmobility.autoapi.value.measurement.Energy;
import com.highmobility.value.Bytes;

public class DrivingModeEnergyConsumption
extends PropertyValueObject {
    public static final int SIZE = 11;
    DrivingMode drivingMode;
    Energy consumption;

    public DrivingMode getDrivingMode() {
        return this.drivingMode;
    }

    public Energy getConsumption() {
        return this.consumption;
    }

    public DrivingModeEnergyConsumption(DrivingMode drivingMode, Energy consumption) {
        super(0);
        this.drivingMode = drivingMode;
        this.consumption = consumption;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, drivingMode.getByte());
        this.set(++bytePosition, consumption);
    }

    public DrivingModeEnergyConsumption(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.drivingMode = DrivingMode.fromByte(this.get(bytePosition));
        int consumptionSize = 10;
        this.consumption = new Energy(this.getRange(++bytePosition, bytePosition + consumptionSize));
    }

    public int getLength() {
        return 11;
    }
}

