/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;

public enum EngineType implements ByteEnum
{
    UNKNOWN(0),
    ALL_ELECTRIC(1),
    COMBUSTION_ENGINE(2),
    PHEV(3),
    HYDROGEN(4),
    HYDROGEN_HYBRID(5),
    PETROL(6),
    ELECTRIC(7),
    GAS(8),
    DIESEL(9),
    GASOLINE(10),
    CNG(11),
    LPG(12),
    HYBRID(13);

    private final byte value;

    public static EngineType fromByte(byte byteValue) throws CommandParseException {
        EngineType[] values = EngineType.values();
        for (int i = 0; i < values.length; ++i) {
            EngineType state = values[i];
            if (state.getByte() != byteValue) continue;
            return state;
        }
        throw new CommandParseException(ByteEnum.enumValueDoesNotExist(EngineType.class.getSimpleName(), byteValue));
    }

    private EngineType(byte value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        return this.value;
    }
}

