/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class Failure
extends PropertyValueObject {
    Reason reason;
    String description;

    public Reason getReason() {
        return this.reason;
    }

    public String getDescription() {
        return this.description;
    }

    public Failure(Reason reason, String description) {
        super(0);
        this.reason = reason;
        this.description = description;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, reason.getByte());
        this.set(++bytePosition, Property.intToBytes(Property.getUtf8Length(description), 2));
        this.set(bytePosition += 2, Property.stringToBytes(description));
    }

    public Failure(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.reason = Reason.fromByte(this.get(bytePosition));
        int descriptionSize = this.getItemSize(++bytePosition);
        this.description = Property.getString(this.bytes, bytePosition += 2, descriptionSize);
    }

    public int getLength() {
        return 1 + Property.getUtf8Length(this.description) + 2;
    }

    public static enum Reason implements ByteEnum
    {
        RATE_LIMIT(0),
        EXECUTION_TIMEOUT(1),
        FORMAT_ERROR(2),
        UNAUTHORISED(3),
        UNKNOWN(4),
        PENDING(5),
        OEM_ERROR(6),
        PRIVACY_MODE_ACTIVE(7);

        private final byte value;

        public static Reason fromByte(byte byteValue) throws CommandParseException {
            Reason[] values = Reason.values();
            for (int i = 0; i < values.length; ++i) {
                Reason state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Reason.class.getSimpleName(), byteValue));
        }

        private Reason(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

