/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;

public enum FluidLevel implements ByteEnum
{
    LOW(0),
    FILLED(1),
    VERY_LOW(2),
    NORMAL(3),
    HIGH(4),
    VERY_HIGH(5);

    private final byte value;

    public static FluidLevel fromByte(byte byteValue) throws CommandParseException {
        FluidLevel[] values = FluidLevel.values();
        for (int i = 0; i < values.length; ++i) {
            FluidLevel state = values[i];
            if (state.getByte() != byteValue) continue;
            return state;
        }
        throw new CommandParseException(ByteEnum.enumValueDoesNotExist(FluidLevel.class.getSimpleName(), byteValue));
    }

    private FluidLevel(byte value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        return this.value;
    }
}

