/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class PriceTariff
extends PropertyValueObject {
    PricingType pricingType;
    Double price;
    String currency;

    public PricingType getPricingType() {
        return this.pricingType;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    public PriceTariff(PricingType pricingType, Double price, String currency) {
        super(0);
        this.pricingType = pricingType;
        this.price = price;
        this.currency = currency;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, pricingType.getByte());
        this.set(++bytePosition, Property.doubleToBytes(price));
        this.set(bytePosition += 8, Property.intToBytes(Property.getUtf8Length(currency), 2));
        this.set(bytePosition += 2, Property.stringToBytes(currency));
    }

    public PriceTariff(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.pricingType = PricingType.fromByte(this.get(bytePosition));
        this.price = Property.getDouble(this.bytes, ++bytePosition);
        int currencySize = this.getItemSize(bytePosition += 8);
        this.currency = Property.getString(this.bytes, bytePosition += 2, currencySize);
    }

    public int getLength() {
        return 9 + Property.getUtf8Length(this.currency) + 2;
    }

    public static enum PricingType implements ByteEnum
    {
        STARTING_FEE(0),
        PER_MINUTE(1),
        PER_KWH(2);

        private final byte value;

        public static PricingType fromByte(byte byteValue) throws CommandParseException {
            PricingType[] values = PricingType.values();
            for (int i = 0; i < values.length; ++i) {
                PricingType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PricingType.class.getSimpleName(), byteValue));
        }

        private PricingType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

