/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Temperature;
import com.highmobility.value.Bytes;

public class TemperatureExtreme
extends PropertyValueObject {
    public static final int SIZE = 11;
    Extreme extreme;
    Temperature temperature;

    public Extreme getExtreme() {
        return this.extreme;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public TemperatureExtreme(Extreme extreme, Temperature temperature) {
        super(0);
        this.extreme = extreme;
        this.temperature = temperature;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, extreme.getByte());
        this.set(++bytePosition, temperature);
    }

    public TemperatureExtreme(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.extreme = Extreme.fromByte(this.get(bytePosition));
        int temperatureSize = 10;
        this.temperature = new Temperature(this.getRange(++bytePosition, bytePosition + temperatureSize));
    }

    public int getLength() {
        return 11;
    }

    public static enum Extreme implements ByteEnum
    {
        HIGHEST(0),
        LOWEST(1);

        private final byte value;

        public static Extreme fromByte(byte byteValue) throws CommandParseException {
            Extreme[] values = Extreme.values();
            for (int i = 0; i < values.length; ++i) {
                Extreme state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Extreme.class.getSimpleName(), byteValue));
        }

        private Extreme(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

