/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;
import java.util.Calendar;

public class Timer
extends PropertyValueObject {
    public static final int SIZE = 9;
    TimerType timerType;
    Calendar date;

    public TimerType getTimerType() {
        return this.timerType;
    }

    public Calendar getDate() {
        return this.date;
    }

    public Timer(TimerType timerType, Calendar date) {
        super(0);
        this.timerType = timerType;
        this.date = date;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, timerType.getByte());
        this.set(++bytePosition, Property.calendarToBytes(date));
    }

    public Timer(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 9) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.timerType = TimerType.fromByte(this.get(bytePosition));
        this.date = Property.getCalendar(this.bytes, ++bytePosition);
    }

    public int getLength() {
        return 9;
    }

    public static enum TimerType implements ByteEnum
    {
        PREFERRED_START_TIME(0),
        PREFERRED_END_TIME(1),
        DEPARTURE_DATE(2);

        private final byte value;

        public static TimerType fromByte(byte byteValue) throws CommandParseException {
            TimerType[] values = TimerType.values();
            for (int i = 0; i < values.length; ++i) {
                TimerType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(TimerType.class.getSimpleName(), byteValue));
        }

        private TimerType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

