/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;

public class TripMeter
extends PropertyValueObject {
    public static final int SIZE = 11;
    Integer id;
    Length distance;

    public Integer getId() {
        return this.id;
    }

    public Length getDistance() {
        return this.distance;
    }

    public TripMeter(Integer id, Length distance) {
        super(0);
        this.id = id;
        this.distance = distance;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(id, 1));
        this.set(++bytePosition, distance);
    }

    public TripMeter(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.id = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        int distanceSize = 10;
        this.distance = new Length(this.getRange(++bytePosition, bytePosition + distanceSize));
    }

    public int getLength() {
        return 11;
    }
}

