/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class TroubleCode
extends PropertyValueObject {
    Integer occurrences;
    String ID;
    String ecuID;
    String status;
    System system;

    public Integer getOccurrences() {
        return this.occurrences;
    }

    public String getID() {
        return this.ID;
    }

    public String getEcuID() {
        return this.ecuID;
    }

    public String getStatus() {
        return this.status;
    }

    public System getSystem() {
        return this.system;
    }

    public TroubleCode(Integer occurrences, String ID, String ecuID, String status, System system) {
        super(0);
        this.occurrences = occurrences;
        this.ID = ID;
        this.ecuID = ecuID;
        this.status = status;
        this.system = system;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(occurrences, 1));
        this.set(++bytePosition, Property.intToBytes(Property.getUtf8Length(ID), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ID));
        this.set(bytePosition += Property.getUtf8Length(ID), Property.intToBytes(Property.getUtf8Length(ecuID), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ecuID));
        this.set(bytePosition += Property.getUtf8Length(ecuID), Property.intToBytes(Property.getUtf8Length(status), 2));
        this.set(bytePosition += 2, Property.stringToBytes(status));
        this.set(bytePosition += Property.getUtf8Length(status), system.getByte());
    }

    public TroubleCode(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 8) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.occurrences = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        int IDSize = this.getItemSize(++bytePosition);
        this.ID = Property.getString(this.bytes, bytePosition += 2, IDSize);
        int ecuIDSize = this.getItemSize(bytePosition += IDSize);
        this.ecuID = Property.getString(this.bytes, bytePosition += 2, ecuIDSize);
        int statusSize = this.getItemSize(bytePosition += ecuIDSize);
        this.status = Property.getString(this.bytes, bytePosition += 2, statusSize);
        this.system = System.fromByte(this.get(bytePosition += statusSize));
    }

    public int getLength() {
        return 1 + Property.getUtf8Length(this.ID) + 2 + Property.getUtf8Length(this.ecuID) + 2 + Property.getUtf8Length(this.status) + 2 + 1;
    }

    public static enum System implements ByteEnum
    {
        UNKNOWN(0),
        BODY(1),
        CHASSIS(2),
        POWERTRAIN(3),
        NETWORK(4);

        private final byte value;

        public static System fromByte(byte byteValue) throws CommandParseException {
            System[] values = System.values();
            for (int i = 0; i < values.length; ++i) {
                System state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(System.class.getSimpleName(), byteValue));
        }

        private System(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

