/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.WindowLocation;
import com.highmobility.value.Bytes;

public class WindowPosition
extends PropertyValueObject {
    public static final int SIZE = 2;
    WindowLocation location;
    Position position;

    public WindowLocation getLocation() {
        return this.location;
    }

    public Position getPosition() {
        return this.position;
    }

    public WindowPosition(WindowLocation location, Position position) {
        super(0);
        this.location = location;
        this.position = position;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, position.getByte());
    }

    public WindowPosition(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = WindowLocation.fromByte(this.get(bytePosition));
        this.position = Position.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Position implements ByteEnum
    {
        CLOSED(0),
        OPEN(1),
        INTERMEDIATE(2);

        private final byte value;

        public static Position fromByte(byte byteValue) throws CommandParseException {
            Position[] values = Position.values();
            for (int i = 0; i < values.length; ++i) {
                Position state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Position.class.getSimpleName(), byteValue));
        }

        private Position(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

