/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class Zone
extends PropertyValueObject {
    public static final int SIZE = 2;
    Integer horizontal;
    Integer vertical;

    public Integer getHorizontal() {
        return this.horizontal;
    }

    public Integer getVertical() {
        return this.vertical;
    }

    public Zone(Integer horizontal, Integer vertical) {
        super(0);
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(horizontal, 1));
        this.set(++bytePosition, Property.intToBytes(vertical, 1));
    }

    public Zone(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.horizontal = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.vertical = Property.getUnsignedInt(this.bytes, ++bytePosition, 1);
    }

    public int getLength() {
        return 2;
    }
}

