/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value.measurement;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.MeasurementType;
import com.highmobility.value.Bytes;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/highmobility/autoapi/value/measurement/Duration;", "Lcom/highmobility/autoapi/value/measurement/MeasurementType;", "value", "", "unit", "Lcom/highmobility/autoapi/value/measurement/Duration$Unit;", "(DLcom/highmobility/autoapi/value/measurement/Duration$Unit;)V", "valueBytes", "Lcom/highmobility/value/Bytes;", "(Lcom/highmobility/value/Bytes;)V", "getUnit", "()Lcom/highmobility/autoapi/value/measurement/Duration$Unit;", "getValue", "()D", "inDays", "inHours", "inMilliseconds", "inMinutes", "inMonths", "inSeconds", "inWeeks", "Unit", "auto-api-java"})
public final class Duration
extends MeasurementType {
    private final double value;
    @NotNull
    private final Unit unit;

    public final double getValue() {
        return this.value;
    }

    @NotNull
    public final Unit getUnit() {
        return this.unit;
    }

    public Duration(double value, @NotNull Unit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        this.bytes[0] = 7;
        this.bytes[1] = unit.getId();
        this.set(2, Property.doubleToBytes(value));
    }

    public Duration(@NotNull Bytes valueBytes) {
        Intrinsics.checkNotNullParameter((Object)valueBytes, (String)"valueBytes");
        super(valueBytes, (byte)7);
        Byte by = valueBytes.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)by, (String)"valueBytes[1]");
        this.unit = Unit.Companion.fromInt(((Number)by).byteValue());
        this.value = Property.getDouble(valueBytes, 2);
    }

    public final double inSeconds() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                d = this.value * 1.0;
                break;
            }
            case 2: {
                d = this.value * 60.0;
                break;
            }
            case 3: {
                d = this.value * 3600.0;
                break;
            }
            case 4: {
                d = this.value * 86400.0;
                break;
            }
            case 5: {
                d = this.value * 604800.0;
                break;
            }
            case 6: {
                d = this.value * 2629800.0;
                break;
            }
            case 7: {
                d = this.value * 0.001;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public final double inMinutes() {
        return this.inSeconds() / 60.0;
    }

    public final double inHours() {
        return this.inSeconds() / 3600.0;
    }

    public final double inDays() {
        return this.inSeconds() / 86400.0;
    }

    public final double inWeeks() {
        return this.inSeconds() / 604800.0;
    }

    public final double inMonths() {
        return this.inSeconds() / 2629800.0;
    }

    public final double inMilliseconds() {
        return this.inSeconds() / 0.001;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/highmobility/autoapi/value/measurement/Duration$Unit;", "", "id", "", "(Ljava/lang/String;IB)V", "getId", "()B", "SECONDS", "MINUTES", "HOURS", "DAYS", "WEEKS", "MONTHS", "MILLISECONDS", "Companion", "auto-api-java"})
    public static final class Unit
    extends Enum<Unit> {
        @NotNull
        public static final Companion Companion;
        private final byte id;
        @NotNull
        private static final Map<Byte, Unit> map;
        public static final /* enum */ Unit SECONDS;
        public static final /* enum */ Unit MINUTES;
        public static final /* enum */ Unit HOURS;
        public static final /* enum */ Unit DAYS;
        public static final /* enum */ Unit WEEKS;
        public static final /* enum */ Unit MONTHS;
        public static final /* enum */ Unit MILLISECONDS;
        private static final /* synthetic */ Unit[] $VALUES;

        private Unit(byte id) {
            this.id = id;
        }

        public final byte getId() {
            return this.id;
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            SECONDS = new Unit(0);
            MINUTES = new Unit(1);
            HOURS = new Unit(2);
            DAYS = new Unit(3);
            WEEKS = new Unit(4);
            MONTHS = new Unit(5);
            MILLISECONDS = new Unit(6);
            $VALUES = unitArray = new Unit[]{Unit.SECONDS, Unit.MINUTES, Unit.HOURS, Unit.DAYS, Unit.WEEKS, Unit.MONTHS, Unit.MILLISECONDS};
            Companion = new Companion(null);
            Unit[] $this$associateBy$iv = Unit.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Unit[] unitArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/highmobility/autoapi/value/measurement/Duration$Unit$Companion;", "", "()V", "map", "", "", "Lcom/highmobility/autoapi/value/measurement/Duration$Unit;", "fromInt", "type", "auto-api-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Unit fromInt(byte type) {
                Unit unit = (Unit)((Object)map.get(type));
                if (unit == null) {
                    throw new CommandParseException();
                }
                return unit;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MINUTES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.HOURS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.DAYS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.WEEKS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MONTHS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MILLISECONDS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

