/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value.measurement;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.MeasurementType;
import com.highmobility.value.Bytes;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/highmobility/autoapi/value/measurement/Length;", "Lcom/highmobility/autoapi/value/measurement/MeasurementType;", "value", "", "unit", "Lcom/highmobility/autoapi/value/measurement/Length$Unit;", "(DLcom/highmobility/autoapi/value/measurement/Length$Unit;)V", "valueBytes", "Lcom/highmobility/value/Bytes;", "(Lcom/highmobility/value/Bytes;)V", "getUnit", "()Lcom/highmobility/autoapi/value/measurement/Length$Unit;", "getValue", "()D", "inCentimeters", "inDecimeters", "inFeet", "inInches", "inKilometers", "inMegameters", "inMeters", "inMiles", "inMillimeters", "inNauticalMiles", "inScandinavianMiles", "inYards", "Unit", "auto-api-java"})
public final class Length
extends MeasurementType {
    private final double value;
    @NotNull
    private final Unit unit;

    public final double getValue() {
        return this.value;
    }

    @NotNull
    public final Unit getUnit() {
        return this.unit;
    }

    public Length(double value, @NotNull Unit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        this.bytes[0] = 18;
        this.bytes[1] = unit.getId();
        this.set(2, Property.doubleToBytes(value));
    }

    public Length(@NotNull Bytes valueBytes) {
        Intrinsics.checkNotNullParameter((Object)valueBytes, (String)"valueBytes");
        super(valueBytes, (byte)18);
        Byte by = valueBytes.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)by, (String)"valueBytes[1]");
        this.unit = Unit.Companion.fromInt(((Number)by).byteValue());
        this.value = Property.getDouble(valueBytes, 2);
    }

    public final double inMeters() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                d = this.value * 1.0;
                break;
            }
            case 2: {
                d = this.value * 0.001;
                break;
            }
            case 3: {
                d = this.value * 0.01;
                break;
            }
            case 4: {
                d = this.value * 0.1;
                break;
            }
            case 5: {
                d = this.value * 1000.0;
                break;
            }
            case 6: {
                d = this.value * 1000000.0;
                break;
            }
            case 7: {
                d = this.value * 0.0254;
                break;
            }
            case 8: {
                d = this.value * 0.3048;
                break;
            }
            case 9: {
                d = this.value * 0.9144;
                break;
            }
            case 10: {
                d = this.value * 1609.344;
                break;
            }
            case 11: {
                d = this.value * 10000.0;
                break;
            }
            case 12: {
                d = this.value * 1852.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public final double inMillimeters() {
        return this.inMeters() / 0.001;
    }

    public final double inCentimeters() {
        return this.inMeters() / 0.01;
    }

    public final double inDecimeters() {
        return this.inMeters() / 0.1;
    }

    public final double inKilometers() {
        return this.inMeters() / 1000.0;
    }

    public final double inMegameters() {
        return this.inMeters() / 1000000.0;
    }

    public final double inInches() {
        return this.inMeters() / 0.0254;
    }

    public final double inFeet() {
        return this.inMeters() / 0.3048;
    }

    public final double inYards() {
        return this.inMeters() / 0.9144;
    }

    public final double inMiles() {
        return this.inMeters() / 1609.344;
    }

    public final double inScandinavianMiles() {
        return this.inMeters() / 10000.0;
    }

    public final double inNauticalMiles() {
        return this.inMeters() / 1852.0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lcom/highmobility/autoapi/value/measurement/Length$Unit;", "", "id", "", "(Ljava/lang/String;IB)V", "getId", "()B", "METERS", "MILLIMETERS", "CENTIMETERS", "DECIMETERS", "KILOMETERS", "MEGAMETERS", "INCHES", "FEET", "YARDS", "MILES", "SCANDINAVIAN_MILES", "NAUTICAL_MILES", "Companion", "auto-api-java"})
    public static final class Unit
    extends Enum<Unit> {
        @NotNull
        public static final Companion Companion;
        private final byte id;
        @NotNull
        private static final Map<Byte, Unit> map;
        public static final /* enum */ Unit METERS;
        public static final /* enum */ Unit MILLIMETERS;
        public static final /* enum */ Unit CENTIMETERS;
        public static final /* enum */ Unit DECIMETERS;
        public static final /* enum */ Unit KILOMETERS;
        public static final /* enum */ Unit MEGAMETERS;
        public static final /* enum */ Unit INCHES;
        public static final /* enum */ Unit FEET;
        public static final /* enum */ Unit YARDS;
        public static final /* enum */ Unit MILES;
        public static final /* enum */ Unit SCANDINAVIAN_MILES;
        public static final /* enum */ Unit NAUTICAL_MILES;
        private static final /* synthetic */ Unit[] $VALUES;

        private Unit(byte id) {
            this.id = id;
        }

        public final byte getId() {
            return this.id;
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            METERS = new Unit(0);
            MILLIMETERS = new Unit(1);
            CENTIMETERS = new Unit(2);
            DECIMETERS = new Unit(3);
            KILOMETERS = new Unit(4);
            MEGAMETERS = new Unit(5);
            INCHES = new Unit(11);
            FEET = new Unit(12);
            YARDS = new Unit(13);
            MILES = new Unit(14);
            SCANDINAVIAN_MILES = new Unit(15);
            NAUTICAL_MILES = new Unit(17);
            $VALUES = unitArray = new Unit[]{Unit.METERS, Unit.MILLIMETERS, Unit.CENTIMETERS, Unit.DECIMETERS, Unit.KILOMETERS, Unit.MEGAMETERS, Unit.INCHES, Unit.FEET, Unit.YARDS, Unit.MILES, Unit.SCANDINAVIAN_MILES, Unit.NAUTICAL_MILES};
            Companion = new Companion(null);
            Unit[] $this$associateBy$iv = Unit.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Unit[] unitArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/highmobility/autoapi/value/measurement/Length$Unit$Companion;", "", "()V", "map", "", "", "Lcom/highmobility/autoapi/value/measurement/Length$Unit;", "fromInt", "type", "auto-api-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Unit fromInt(byte type) {
                Unit unit = (Unit)((Object)map.get(type));
                if (unit == null) {
                    throw new CommandParseException();
                }
                return unit;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.METERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MILLIMETERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CENTIMETERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.DECIMETERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.KILOMETERS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MEGAMETERS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.INCHES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.FEET.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.YARDS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MILES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.SCANDINAVIAN_MILES.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.NAUTICAL_MILES.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

