/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value.measurement;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.MeasurementType;
import com.highmobility.value.Bytes;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/highmobility/autoapi/value/measurement/Mass;", "Lcom/highmobility/autoapi/value/measurement/MeasurementType;", "value", "", "unit", "Lcom/highmobility/autoapi/value/measurement/Mass$Unit;", "(DLcom/highmobility/autoapi/value/measurement/Mass$Unit;)V", "valueBytes", "Lcom/highmobility/value/Bytes;", "(Lcom/highmobility/value/Bytes;)V", "getUnit", "()Lcom/highmobility/autoapi/value/measurement/Mass$Unit;", "getValue", "()D", "inCarats", "inCentigrams", "inDecigrams", "inGrams", "inKilograms", "inMetricTons", "inMicrograms", "inMilligrams", "inNanograms", "inOunces", "inOuncesTroy", "inPicograms", "inPounds", "inShortTons", "inSlugs", "inStones", "Unit", "auto-api-java"})
public final class Mass
extends MeasurementType {
    private final double value;
    @NotNull
    private final Unit unit;

    public final double getValue() {
        return this.value;
    }

    @NotNull
    public final Unit getUnit() {
        return this.unit;
    }

    public Mass(double value, @NotNull Unit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        this.bytes[0] = 19;
        this.bytes[1] = unit.getId();
        this.set(2, Property.doubleToBytes(value));
    }

    public Mass(@NotNull Bytes valueBytes) {
        Intrinsics.checkNotNullParameter((Object)valueBytes, (String)"valueBytes");
        super(valueBytes, (byte)19);
        Byte by = valueBytes.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)by, (String)"valueBytes[1]");
        this.unit = Unit.Companion.fromInt(((Number)by).byteValue());
        this.value = Property.getDouble(valueBytes, 2);
    }

    public final double inKilograms() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                d = this.value * 1.0;
                break;
            }
            case 2: {
                d = this.value * 0.001;
                break;
            }
            case 3: {
                d = this.value * 1.0E-4;
                break;
            }
            case 4: {
                d = this.value * 1.0E-5;
                break;
            }
            case 5: {
                d = this.value * 1.0E-6;
                break;
            }
            case 6: {
                d = this.value * 1.0E-9;
                break;
            }
            case 7: {
                d = this.value * 1.0E-12;
                break;
            }
            case 8: {
                d = this.value * 1.0E-15;
                break;
            }
            case 9: {
                d = this.value * 0.0283495;
                break;
            }
            case 10: {
                d = this.value * 0.453592;
                break;
            }
            case 11: {
                d = this.value * 0.157473;
                break;
            }
            case 12: {
                d = this.value * 1000.0;
                break;
            }
            case 13: {
                d = this.value * 907.185;
                break;
            }
            case 14: {
                d = this.value * 2.0E-4;
                break;
            }
            case 15: {
                d = this.value * 0.03110348;
                break;
            }
            case 16: {
                d = this.value * 14.5939;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public final double inGrams() {
        return this.inKilograms() / 0.001;
    }

    public final double inDecigrams() {
        return this.inKilograms() / 1.0E-4;
    }

    public final double inCentigrams() {
        return this.inKilograms() / 1.0E-5;
    }

    public final double inMilligrams() {
        return this.inKilograms() / 1.0E-6;
    }

    public final double inMicrograms() {
        return this.inKilograms() / 1.0E-9;
    }

    public final double inNanograms() {
        return this.inKilograms() / 1.0E-12;
    }

    public final double inPicograms() {
        return this.inKilograms() / 1.0E-15;
    }

    public final double inOunces() {
        return this.inKilograms() / 0.0283495;
    }

    public final double inPounds() {
        return this.inKilograms() / 0.453592;
    }

    public final double inStones() {
        return this.inKilograms() / 0.157473;
    }

    public final double inMetricTons() {
        return this.inKilograms() / 1000.0;
    }

    public final double inShortTons() {
        return this.inKilograms() / 907.185;
    }

    public final double inCarats() {
        return this.inKilograms() / 2.0E-4;
    }

    public final double inOuncesTroy() {
        return this.inKilograms() / 0.03110348;
    }

    public final double inSlugs() {
        return this.inKilograms() / 14.5939;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0015\b\u0086\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Lcom/highmobility/autoapi/value/measurement/Mass$Unit;", "", "id", "", "(Ljava/lang/String;IB)V", "getId", "()B", "KILOGRAMS", "GRAMS", "DECIGRAMS", "CENTIGRAMS", "MILLIGRAMS", "MICROGRAMS", "NANOGRAMS", "PICOGRAMS", "OUNCES", "POUNDS", "STONES", "METRIC_TONS", "SHORT_TONS", "CARATS", "OUNCES_TROY", "SLUGS", "Companion", "auto-api-java"})
    public static final class Unit
    extends Enum<Unit> {
        @NotNull
        public static final Companion Companion;
        private final byte id;
        @NotNull
        private static final Map<Byte, Unit> map;
        public static final /* enum */ Unit KILOGRAMS;
        public static final /* enum */ Unit GRAMS;
        public static final /* enum */ Unit DECIGRAMS;
        public static final /* enum */ Unit CENTIGRAMS;
        public static final /* enum */ Unit MILLIGRAMS;
        public static final /* enum */ Unit MICROGRAMS;
        public static final /* enum */ Unit NANOGRAMS;
        public static final /* enum */ Unit PICOGRAMS;
        public static final /* enum */ Unit OUNCES;
        public static final /* enum */ Unit POUNDS;
        public static final /* enum */ Unit STONES;
        public static final /* enum */ Unit METRIC_TONS;
        public static final /* enum */ Unit SHORT_TONS;
        public static final /* enum */ Unit CARATS;
        public static final /* enum */ Unit OUNCES_TROY;
        public static final /* enum */ Unit SLUGS;
        private static final /* synthetic */ Unit[] $VALUES;

        private Unit(byte id) {
            this.id = id;
        }

        public final byte getId() {
            return this.id;
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            KILOGRAMS = new Unit(0);
            GRAMS = new Unit(1);
            DECIGRAMS = new Unit(2);
            CENTIGRAMS = new Unit(3);
            MILLIGRAMS = new Unit(4);
            MICROGRAMS = new Unit(5);
            NANOGRAMS = new Unit(6);
            PICOGRAMS = new Unit(7);
            OUNCES = new Unit(8);
            POUNDS = new Unit(9);
            STONES = new Unit(10);
            METRIC_TONS = new Unit(11);
            SHORT_TONS = new Unit(12);
            CARATS = new Unit(13);
            OUNCES_TROY = new Unit(14);
            SLUGS = new Unit(15);
            $VALUES = unitArray = new Unit[]{Unit.KILOGRAMS, Unit.GRAMS, Unit.DECIGRAMS, Unit.CENTIGRAMS, Unit.MILLIGRAMS, Unit.MICROGRAMS, Unit.NANOGRAMS, Unit.PICOGRAMS, Unit.OUNCES, Unit.POUNDS, Unit.STONES, Unit.METRIC_TONS, Unit.SHORT_TONS, Unit.CARATS, Unit.OUNCES_TROY, Unit.SLUGS};
            Companion = new Companion(null);
            Unit[] $this$associateBy$iv = Unit.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Unit[] unitArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/highmobility/autoapi/value/measurement/Mass$Unit$Companion;", "", "()V", "map", "", "", "Lcom/highmobility/autoapi/value/measurement/Mass$Unit;", "fromInt", "type", "auto-api-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Unit fromInt(byte type) {
                Unit unit = (Unit)((Object)map.get(type));
                if (unit == null) {
                    throw new CommandParseException();
                }
                return unit;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.KILOGRAMS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.GRAMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.DECIGRAMS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CENTIGRAMS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MILLIGRAMS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MICROGRAMS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.NANOGRAMS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.PICOGRAMS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.OUNCES.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.POUNDS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.STONES.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.METRIC_TONS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.SHORT_TONS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CARATS.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.OUNCES_TROY.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.SLUGS.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

