/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value.measurement;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.MeasurementType;
import com.highmobility.value.Bytes;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/highmobility/autoapi/value/measurement/Volume;", "Lcom/highmobility/autoapi/value/measurement/MeasurementType;", "value", "", "unit", "Lcom/highmobility/autoapi/value/measurement/Volume$Unit;", "(DLcom/highmobility/autoapi/value/measurement/Volume$Unit;)V", "valueBytes", "Lcom/highmobility/value/Bytes;", "(Lcom/highmobility/value/Bytes;)V", "getUnit", "()Lcom/highmobility/autoapi/value/measurement/Volume$Unit;", "getValue", "()D", "inCentiliters", "inCubicCentimeters", "inCubicDecimeters", "inCubicFeet", "inCubicInches", "inCubicMeters", "inCubicMillimeters", "inDeciliters", "inFluidOunces", "inGallons", "inImperialFluidOunces", "inImperialGallons", "inLiters", "inMilliliters", "Unit", "auto-api-java"})
public final class Volume
extends MeasurementType {
    private final double value;
    @NotNull
    private final Unit unit;

    public final double getValue() {
        return this.value;
    }

    @NotNull
    public final Unit getUnit() {
        return this.unit;
    }

    public Volume(double value, @NotNull Unit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        this.bytes[0] = 25;
        this.bytes[1] = unit.getId();
        this.set(2, Property.doubleToBytes(value));
    }

    public Volume(@NotNull Bytes valueBytes) {
        Intrinsics.checkNotNullParameter((Object)valueBytes, (String)"valueBytes");
        super(valueBytes, (byte)25);
        Byte by = valueBytes.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)by, (String)"valueBytes[1]");
        this.unit = Unit.Companion.fromInt(((Number)by).byteValue());
        this.value = Property.getDouble(valueBytes, 2);
    }

    public final double inLiters() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                d = this.value * 1.0;
                break;
            }
            case 2: {
                d = this.value * 0.001;
                break;
            }
            case 3: {
                d = this.value * 0.01;
                break;
            }
            case 4: {
                d = this.value * 0.1;
                break;
            }
            case 5: {
                d = this.value * 1.0E-6;
                break;
            }
            case 6: {
                d = this.value * 0.001;
                break;
            }
            case 7: {
                d = this.value * 1.0;
                break;
            }
            case 8: {
                d = this.value * 1000.0;
                break;
            }
            case 9: {
                d = this.value * 0.016387064;
                break;
            }
            case 10: {
                d = this.value * 28.316846592;
                break;
            }
            case 11: {
                d = this.value * 0.0295735296875;
                break;
            }
            case 12: {
                d = this.value * 3.785411784;
                break;
            }
            case 13: {
                d = this.value * 0.0284130625;
                break;
            }
            case 14: {
                d = this.value * 4.54609;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public final double inMilliliters() {
        return this.inLiters() / 0.001;
    }

    public final double inCentiliters() {
        return this.inLiters() / 0.01;
    }

    public final double inDeciliters() {
        return this.inLiters() / 0.1;
    }

    public final double inCubicMillimeters() {
        return this.inLiters() / 1.0E-6;
    }

    public final double inCubicCentimeters() {
        return this.inLiters() / 0.001;
    }

    public final double inCubicDecimeters() {
        return this.inLiters() / 1.0;
    }

    public final double inCubicMeters() {
        return this.inLiters() / 1000.0;
    }

    public final double inCubicInches() {
        return this.inLiters() / 0.016387064;
    }

    public final double inCubicFeet() {
        return this.inLiters() / 28.316846592;
    }

    public final double inFluidOunces() {
        return this.inLiters() / 0.0295735296875;
    }

    public final double inGallons() {
        return this.inLiters() / 3.785411784;
    }

    public final double inImperialFluidOunces() {
        return this.inLiters() / 0.0284130625;
    }

    public final double inImperialGallons() {
        return this.inLiters() / 4.54609;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0013\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lcom/highmobility/autoapi/value/measurement/Volume$Unit;", "", "id", "", "(Ljava/lang/String;IB)V", "getId", "()B", "LITERS", "MILLILITERS", "CENTILITERS", "DECILITERS", "CUBIC_MILLIMETERS", "CUBIC_CENTIMETERS", "CUBIC_DECIMETERS", "CUBIC_METERS", "CUBIC_INCHES", "CUBIC_FEET", "FLUID_OUNCES", "GALLONS", "IMPERIAL_FLUID_OUNCES", "IMPERIAL_GALLONS", "Companion", "auto-api-java"})
    public static final class Unit
    extends Enum<Unit> {
        @NotNull
        public static final Companion Companion;
        private final byte id;
        @NotNull
        private static final Map<Byte, Unit> map;
        public static final /* enum */ Unit LITERS;
        public static final /* enum */ Unit MILLILITERS;
        public static final /* enum */ Unit CENTILITERS;
        public static final /* enum */ Unit DECILITERS;
        public static final /* enum */ Unit CUBIC_MILLIMETERS;
        public static final /* enum */ Unit CUBIC_CENTIMETERS;
        public static final /* enum */ Unit CUBIC_DECIMETERS;
        public static final /* enum */ Unit CUBIC_METERS;
        public static final /* enum */ Unit CUBIC_INCHES;
        public static final /* enum */ Unit CUBIC_FEET;
        public static final /* enum */ Unit FLUID_OUNCES;
        public static final /* enum */ Unit GALLONS;
        public static final /* enum */ Unit IMPERIAL_FLUID_OUNCES;
        public static final /* enum */ Unit IMPERIAL_GALLONS;
        private static final /* synthetic */ Unit[] $VALUES;

        private Unit(byte id) {
            this.id = id;
        }

        public final byte getId() {
            return this.id;
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            LITERS = new Unit(2);
            MILLILITERS = new Unit(3);
            CENTILITERS = new Unit(4);
            DECILITERS = new Unit(5);
            CUBIC_MILLIMETERS = new Unit(10);
            CUBIC_CENTIMETERS = new Unit(9);
            CUBIC_DECIMETERS = new Unit(8);
            CUBIC_METERS = new Unit(7);
            CUBIC_INCHES = new Unit(11);
            CUBIC_FEET = new Unit(12);
            FLUID_OUNCES = new Unit(19);
            GALLONS = new Unit(23);
            IMPERIAL_FLUID_OUNCES = new Unit(26);
            IMPERIAL_GALLONS = new Unit(29);
            $VALUES = unitArray = new Unit[]{Unit.LITERS, Unit.MILLILITERS, Unit.CENTILITERS, Unit.DECILITERS, Unit.CUBIC_MILLIMETERS, Unit.CUBIC_CENTIMETERS, Unit.CUBIC_DECIMETERS, Unit.CUBIC_METERS, Unit.CUBIC_INCHES, Unit.CUBIC_FEET, Unit.FLUID_OUNCES, Unit.GALLONS, Unit.IMPERIAL_FLUID_OUNCES, Unit.IMPERIAL_GALLONS};
            Companion = new Companion(null);
            Unit[] $this$associateBy$iv = Unit.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Unit[] unitArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.id, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/highmobility/autoapi/value/measurement/Volume$Unit$Companion;", "", "()V", "map", "", "", "Lcom/highmobility/autoapi/value/measurement/Volume$Unit;", "fromInt", "type", "auto-api-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Unit fromInt(byte type) {
                Unit unit = (Unit)((Object)map.get(type));
                if (unit == null) {
                    throw new CommandParseException();
                }
                return unit;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.LITERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.MILLILITERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CENTILITERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.DECILITERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_MILLIMETERS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_CENTIMETERS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_DECIMETERS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_METERS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_INCHES.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.CUBIC_FEET.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.FLUID_OUNCES.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.GALLONS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.IMPERIAL_FLUID_OUNCES.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.IMPERIAL_GALLONS.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

