/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateProjectOptions
extends GenericModel {
    protected String name;
    protected String resourceGroupId;
    protected List<String> tags;

    protected CreateProjectOptions() {
    }

    protected CreateProjectOptions(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        this.name = builder.name;
        this.resourceGroupId = builder.resourceGroupId;
        this.tags = builder.tags;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String resourceGroupId() {
        return this.resourceGroupId;
    }

    public List<String> tags() {
        return this.tags;
    }

    public static class Builder {
        private String name;
        private String resourceGroupId;
        private List<String> tags;

        private Builder(CreateProjectOptions createProjectOptions) {
            this.name = createProjectOptions.name;
            this.resourceGroupId = createProjectOptions.resourceGroupId;
            this.tags = createProjectOptions.tags;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public CreateProjectOptions build() {
            return new CreateProjectOptions(this);
        }

        public Builder addTags(String tags) {
            Validator.notNull(tags, "tags cannot be null");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(tags);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }
    }
}

