/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.cloud.sdk.core.util.ByteArrayTypeAdapter;
import com.ibm.cloud.sdk.core.util.DateTimeTypeAdapter;
import com.ibm.cloud.sdk.core.util.DiscriminatorBasedTypeAdapterFactory;
import com.ibm.cloud.sdk.core.util.DynamicModelTypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GsonSingleton {
    private static final Logger LOG = Logger.getLogger(GsonSingleton.class.getName());
    private static Gson gson;
    private static Gson gsonWithoutPrinting;
    public static final TypeAdapter<Number> LAZILY_PARSED_NUMBER_ADAPTER;

    private GsonSingleton() {
    }

    private static Gson createGson(boolean prettyPrint, boolean serializeNulls) {
        LOG.log(Level.FINE, "Creating new Gson context; prettyPrint={0}, serializeNulls={1}", new Object[]{prettyPrint, serializeNulls});
        GsonBuilder builder = new GsonBuilder().setObjectToNumberStrategy(ToNumberPolicy.LAZILY_PARSED_NUMBER).setNumberToNumberStrategy(ToNumberPolicy.LAZILY_PARSED_NUMBER);
        GsonSingleton.registerTypeAdapters(builder);
        if (prettyPrint) {
            builder.setPrettyPrinting();
        }
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.disableHtmlEscaping();
        return builder.create();
    }

    private static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTimeTypeAdapter());
        LOG.log(Level.FINE, "Registered type adapter {0} for type {1}", new Object[]{DateTimeTypeAdapter.class.getSimpleName(), Date.class.getName()});
        builder.registerTypeAdapter((Type)((Object)byte[].class), new ByteArrayTypeAdapter());
        LOG.log(Level.FINE, "Registered type adapter {0} for type {1}", new Object[]{ByteArrayTypeAdapter.class.getSimpleName(), "byte[]"});
        builder.registerTypeAdapter((Type)((Object)LazilyParsedNumber.class), LAZILY_PARSED_NUMBER_ADAPTER);
        LOG.log(Level.FINE, "Registered type adapter {0} for type {1}", new Object[]{LAZILY_PARSED_NUMBER_ADAPTER.getClass().getName(), LazilyParsedNumber.class.getName()});
        builder.registerTypeAdapterFactory(new DynamicModelTypeAdapterFactory());
        LOG.log(Level.FINE, "Registered type adapter factory {0}", DynamicModelTypeAdapterFactory.class.getName());
        builder.registerTypeAdapterFactory(new DiscriminatorBasedTypeAdapterFactory());
        LOG.log(Level.FINE, "Registered type adapter factory {0}", DiscriminatorBasedTypeAdapterFactory.class.getName());
    }

    public static synchronized Gson getGson() {
        if (gson == null) {
            gson = GsonSingleton.createGson(true, false);
        }
        return gson;
    }

    public static synchronized Gson getGsonWithoutPrettyPrinting() {
        if (gsonWithoutPrinting == null) {
            gsonWithoutPrinting = GsonSingleton.createGson(false, false);
        }
        return gsonWithoutPrinting;
    }

    public static Gson getGsonWithSerializeNulls() {
        return GsonSingleton.createGson(false, true);
    }

    static {
        LAZILY_PARSED_NUMBER_ADAPTER = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader in) throws IOException {
                JsonToken jsonToken = in.peek();
                switch (jsonToken) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                    case NUMBER: 
                    case STRING: {
                        return new LazilyParsedNumber(in.nextString());
                    }
                }
                throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
            }

            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                out.value(value);
            }
        };
    }
}

