/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.AllowedOutboundDestination;
import com.ibm.cloud.code_engine.code_engine.v2.model.AllowedOutboundDestinationList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAllowedOutboundDestinationOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class AllowedOutboundDestinationPager {
    protected boolean hasNext;
    protected ListAllowedOutboundDestinationOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected AllowedOutboundDestinationPager() {
    }

    public AllowedOutboundDestinationPager(CodeEngine client, ListAllowedOutboundDestinationOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<AllowedOutboundDestination> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListAllowedOutboundDestinationOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        AllowedOutboundDestinationList result = this.client.listAllowedOutboundDestination(this.options).execute().getResult();
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getAllowedOutboundDestinations();
    }

    public List<AllowedOutboundDestination> getAll() {
        ArrayList<AllowedOutboundDestination> results = new ArrayList<AllowedOutboundDestination>();
        while (this.hasNext()) {
            List<AllowedOutboundDestination> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

