/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMap;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMapList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListConfigMapsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ConfigMapsPager {
    protected boolean hasNext;
    protected ListConfigMapsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected ConfigMapsPager() {
    }

    public ConfigMapsPager(CodeEngine client, ListConfigMapsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<ConfigMap> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListConfigMapsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        ConfigMapList result = this.client.listConfigMaps(this.options).execute().getResult();
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getConfigMaps();
    }

    public List<ConfigMap> getAll() {
        ArrayList<ConfigMap> results = new ArrayList<ConfigMap>();
        while (this.hasNext()) {
            List<ConfigMap> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

