/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.code_engine.code_engine.v2.model.EnvVarPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FunctionPatch
extends GenericModel {
    @SerializedName(value="code_binary")
    protected Boolean codeBinary;
    @SerializedName(value="code_main")
    protected String codeMain;
    @SerializedName(value="code_reference")
    protected String codeReference;
    @SerializedName(value="code_secret")
    protected String codeSecret;
    @SerializedName(value="managed_domain_mappings")
    protected String managedDomainMappings;
    @SerializedName(value="run_env_variables")
    protected List<EnvVarPrototype> runEnvVariables;
    protected String runtime;
    @SerializedName(value="scale_concurrency")
    protected Long scaleConcurrency;
    @SerializedName(value="scale_cpu_limit")
    protected String scaleCpuLimit;
    @SerializedName(value="scale_down_delay")
    protected Long scaleDownDelay;
    @SerializedName(value="scale_max_execution_time")
    protected Long scaleMaxExecutionTime;
    @SerializedName(value="scale_memory_limit")
    protected String scaleMemoryLimit;

    protected FunctionPatch() {
    }

    protected FunctionPatch(Builder builder) {
        this.codeBinary = builder.codeBinary;
        this.codeMain = builder.codeMain;
        this.codeReference = builder.codeReference;
        this.codeSecret = builder.codeSecret;
        this.managedDomainMappings = builder.managedDomainMappings;
        this.runEnvVariables = builder.runEnvVariables;
        this.runtime = builder.runtime;
        this.scaleConcurrency = builder.scaleConcurrency;
        this.scaleCpuLimit = builder.scaleCpuLimit;
        this.scaleDownDelay = builder.scaleDownDelay;
        this.scaleMaxExecutionTime = builder.scaleMaxExecutionTime;
        this.scaleMemoryLimit = builder.scaleMemoryLimit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean codeBinary() {
        return this.codeBinary;
    }

    public String codeMain() {
        return this.codeMain;
    }

    public String codeReference() {
        return this.codeReference;
    }

    public String codeSecret() {
        return this.codeSecret;
    }

    public String managedDomainMappings() {
        return this.managedDomainMappings;
    }

    public List<EnvVarPrototype> runEnvVariables() {
        return this.runEnvVariables;
    }

    public String runtime() {
        return this.runtime;
    }

    public Long scaleConcurrency() {
        return this.scaleConcurrency;
    }

    public String scaleCpuLimit() {
        return this.scaleCpuLimit;
    }

    public Long scaleDownDelay() {
        return this.scaleDownDelay;
    }

    public Long scaleMaxExecutionTime() {
        return this.scaleMaxExecutionTime;
    }

    public String scaleMemoryLimit() {
        return this.scaleMemoryLimit;
    }

    public Map<String, Object> asPatch() {
        return GsonSingleton.getGson().fromJson(this.toString(), Map.class);
    }

    public static class Builder {
        private Boolean codeBinary;
        private String codeMain;
        private String codeReference;
        private String codeSecret;
        private String managedDomainMappings;
        private List<EnvVarPrototype> runEnvVariables;
        private String runtime;
        private Long scaleConcurrency;
        private String scaleCpuLimit;
        private Long scaleDownDelay;
        private Long scaleMaxExecutionTime;
        private String scaleMemoryLimit;

        private Builder(FunctionPatch functionPatch) {
            this.codeBinary = functionPatch.codeBinary;
            this.codeMain = functionPatch.codeMain;
            this.codeReference = functionPatch.codeReference;
            this.codeSecret = functionPatch.codeSecret;
            this.managedDomainMappings = functionPatch.managedDomainMappings;
            this.runEnvVariables = functionPatch.runEnvVariables;
            this.runtime = functionPatch.runtime;
            this.scaleConcurrency = functionPatch.scaleConcurrency;
            this.scaleCpuLimit = functionPatch.scaleCpuLimit;
            this.scaleDownDelay = functionPatch.scaleDownDelay;
            this.scaleMaxExecutionTime = functionPatch.scaleMaxExecutionTime;
            this.scaleMemoryLimit = functionPatch.scaleMemoryLimit;
        }

        public Builder() {
        }

        public FunctionPatch build() {
            return new FunctionPatch(this);
        }

        public Builder addRunEnvVariables(EnvVarPrototype runEnvVariables) {
            Validator.notNull(runEnvVariables, "runEnvVariables cannot be null");
            if (this.runEnvVariables == null) {
                this.runEnvVariables = new ArrayList<EnvVarPrototype>();
            }
            this.runEnvVariables.add(runEnvVariables);
            return this;
        }

        public Builder codeBinary(Boolean codeBinary) {
            this.codeBinary = codeBinary;
            return this;
        }

        public Builder codeMain(String codeMain) {
            this.codeMain = codeMain;
            return this;
        }

        public Builder codeReference(String codeReference) {
            this.codeReference = codeReference;
            return this;
        }

        public Builder codeSecret(String codeSecret) {
            this.codeSecret = codeSecret;
            return this;
        }

        public Builder managedDomainMappings(String managedDomainMappings) {
            this.managedDomainMappings = managedDomainMappings;
            return this;
        }

        public Builder runEnvVariables(List<EnvVarPrototype> runEnvVariables) {
            this.runEnvVariables = runEnvVariables;
            return this;
        }

        public Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder scaleConcurrency(long scaleConcurrency) {
            this.scaleConcurrency = scaleConcurrency;
            return this;
        }

        public Builder scaleCpuLimit(String scaleCpuLimit) {
            this.scaleCpuLimit = scaleCpuLimit;
            return this;
        }

        public Builder scaleDownDelay(long scaleDownDelay) {
            this.scaleDownDelay = scaleDownDelay;
            return this;
        }

        public Builder scaleMaxExecutionTime(long scaleMaxExecutionTime) {
            this.scaleMaxExecutionTime = scaleMaxExecutionTime;
            return this;
        }

        public Builder scaleMemoryLimit(String scaleMemoryLimit) {
            this.scaleMemoryLimit = scaleMemoryLimit;
            return this;
        }
    }

    public static interface ManagedDomainMappings {
        public static final String LOCAL = "local";
        public static final String LOCAL_PRIVATE = "local_private";
        public static final String LOCAL_PUBLIC = "local_public";
    }
}

