/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.security.IamRequestBasedAuthenticatorImmutable;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.net.Proxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;

public class IamAssumeAuthenticator
extends IamRequestBasedAuthenticatorImmutable
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(IamAssumeAuthenticator.class.getName());
    private static final String OPERATION_PATH = "/identity/token";
    private String iamProfileCrn;
    private String iamProfileId;
    private String iamProfileName;
    private String iamAccountId;
    private IamAuthenticator iamDelegate;

    protected IamAssumeAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("iam-assume-authenticator"));
    }

    protected IamAssumeAuthenticator(Builder builder) {
        this();
        IamAuthenticator iamDelegate;
        this.iamDelegate = iamDelegate = new IamAuthenticator.Builder().apikey(builder.apikey).scope(builder.scope).clientId(builder.clientId).clientSecret(builder.clientSecret).url(builder.url).disableSSLVerification(builder.disableSSLVerification).headers(builder.headers).proxy(builder.proxy).proxyAuthenticator(builder.proxyAuthenticator).build();
        iamDelegate.setClient(builder.client);
        this.iamProfileCrn = builder.iamProfileCrn;
        this.iamProfileId = builder.iamProfileId;
        this.iamProfileName = builder.iamProfileName;
        this.iamAccountId = builder.iamAccountId;
        this._setURL(builder.url);
        this._setDisableSSLVerification(builder.disableSSLVerification);
        this._setHeaders(builder.headers);
        this._setProxy(builder.proxy);
        this._setProxyAuthenticator(builder.proxyAuthenticator);
        this._setClient(builder.client);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static IamAssumeAuthenticator fromConfiguration(Map<String, String> config) {
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty(apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        return new Builder().iamProfileCrn(config.get("IAM_PROFILE_CRN")).iamProfileId(config.get("IAM_PROFILE_ID")).iamProfileName(config.get("IAM_PROFILE_NAME")).iamAccountId(config.get("IAM_ACCOUNT_ID")).url(config.get("AUTH_URL")).apikey(apikey).scope(config.get("SCOPE")).clientId(config.get("CLIENT_ID")).clientSecret(config.get("CLIENT_SECRET")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isEmpty(this.getURL())) {
            this._setURL("https://iam.cloud.ibm.com");
        } else {
            this._setURL(StringUtils.removeEnd(this.getURL(), OPERATION_PATH));
        }
        int numParams = 0;
        if (StringUtils.isNotEmpty(this.getIamProfileCrn())) {
            ++numParams;
        }
        if (StringUtils.isNotEmpty(this.getIamProfileId())) {
            ++numParams;
        }
        if (StringUtils.isNotEmpty(this.getIamProfileName())) {
            ++numParams;
        }
        if (numParams != 1) {
            throw new IllegalArgumentException(String.format("Exactly one of %s or %s must be specified.", "iamProfileCrn, iamProfileId", "iamProfileName"));
        }
        if (StringUtils.isEmpty(this.getIamProfileName()) != StringUtils.isEmpty(this.getIamAccountId())) {
            throw new IllegalArgumentException("iamAccountId must be specified if and only if iamProfileName is specified");
        }
    }

    @Override
    public String authenticationType() {
        return "iamAssume";
    }

    public String getIamProfileCrn() {
        return this.iamProfileCrn;
    }

    public String getIamProfileId() {
        return this.iamProfileId;
    }

    public String getIamProfileName() {
        return this.iamProfileName;
    }

    public String getIamAccountId() {
        return this.iamAccountId;
    }

    @Override
    public IamToken requestToken() {
        IamToken token;
        String userAccessToken = this.iamDelegate.getToken();
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getURL(), OPERATION_PATH));
        builder.header("Accept", "application/json");
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        builder.header("User-Agent", this.getUserAgent());
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add("grant_type", "urn:ibm:params:oauth:grant-type:assume").add("access_token", userAccessToken);
        if (StringUtils.isNotEmpty(this.getIamProfileCrn())) {
            formBodyBuilder.add("profile_crn", this.getIamProfileCrn());
        } else if (StringUtils.isNotEmpty(this.getIamProfileId())) {
            formBodyBuilder.add("profile_id", this.getIamProfileId());
        } else {
            formBodyBuilder.add("profile_name", this.getIamProfileName());
            formBodyBuilder.add("account", this.getIamAccountId());
        }
        FormBody formBody = formBodyBuilder.build();
        builder.body(formBody);
        try {
            LOG.log(Level.FINE, "Invoking IAM 'get_token (assume)' operation: POST {0}", builder.toUrl());
            token = this.invokeRequest(builder, IamToken.class);
            LOG.log(Level.FINE, "Returned from IAM 'get_token (assume)' operation");
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Exception from IAM 'get_token (assume)' operation: ", t);
            token = new IamToken(t);
        }
        return token;
    }

    public static class Builder {
        private String apikey;
        private String scope;
        private String clientId;
        private String clientSecret;
        private String iamProfileCrn;
        private String iamProfileId;
        private String iamProfileName;
        private String iamAccountId;
        private String url;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;
        private OkHttpClient client;

        public Builder() {
        }

        private Builder(IamAssumeAuthenticator obj) {
            if (obj.iamDelegate != null) {
                this.apikey = obj.iamDelegate.getApiKey();
                this.scope = obj.iamDelegate.getScope();
                this.clientId = obj.iamDelegate.getClientId();
                this.clientSecret = obj.iamDelegate.getClientSecret();
            }
            this.iamProfileCrn = obj.getIamProfileCrn();
            this.iamProfileId = obj.getIamProfileId();
            this.iamProfileName = obj.getIamProfileName();
            this.iamAccountId = obj.getIamAccountId();
            this.url = obj.getURL();
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public IamAssumeAuthenticator build() {
            return new IamAssumeAuthenticator(this);
        }

        public Builder iamProfileCrn(String iamProfileCrn) {
            this.iamProfileCrn = iamProfileCrn;
            return this;
        }

        public Builder iamProfileId(String iamProfileId) {
            this.iamProfileId = iamProfileId;
            return this;
        }

        public Builder iamProfileName(String iamProfileName) {
            this.iamProfileName = iamProfileName;
            return this;
        }

        public Builder iamAccountId(String iamAccountId) {
            this.iamAccountId = iamAccountId;
            return this;
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }
    }
}

