/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DiscriminatorBasedTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger LOGGER = Logger.getLogger(DiscriminatorBasedTypeAdapterFactory.class.getName());
    private static final String DISC_PROPERTY_NAME_FIELD = "discriminatorPropertyName";
    private static final String DISC_MAPPING_FIELD = "discriminatorMapping";

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        LOGGER.log(Level.FINE, "{0} examining class: {1}", new Object[]{this.getClass().getSimpleName(), rawType.getName()});
        DiscriminatorMetadata discMetadata = this.getDiscriminatorMetadata(rawType);
        if (discMetadata != null) {
            LOGGER.log(Level.FINE, "Returning TypeAdapter instance to handle class: {0}", rawType.getName());
            return new Adapter(gson, discMetadata);
        }
        LOGGER.log(Level.FINE, "Discriminator metadata not found in class: {0}", rawType.getName());
        return null;
    }

    private DiscriminatorMetadata getDiscriminatorMetadata(Class<?> clazz) {
        try {
            Field mappingField;
            String propName = null;
            Map mapping = null;
            Field propNameField = clazz.getDeclaredField(DISC_PROPERTY_NAME_FIELD);
            if (propNameField != null) {
                propNameField.setAccessible(true);
                propName = (String)propNameField.get(null);
            }
            if ((mappingField = clazz.getDeclaredField(DISC_MAPPING_FIELD)) != null) {
                mappingField.setAccessible(true);
                mapping = (Map)mappingField.get(null);
            }
            if (propName != null && mapping != null) {
                return new DiscriminatorMetadata(clazz, propName, mapping);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static class Adapter<T>
    extends TypeAdapter<T> {
        private Gson gson;
        private DiscriminatorMetadata discMetadata;

        Adapter(Gson gson, DiscriminatorMetadata discMetadata) {
            this.gson = gson;
            this.discMetadata = discMetadata;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            LOGGER.log(Level.FINEST, "Serializing JSON object for discriminator class: {0}", this.discMetadata.getDiscriminatorClass().getName());
            if (value == null) {
                out.nullValue();
                return;
            }
            TypeAdapter<?> adapter = this.gson.getAdapter(value.getClass());
            if (adapter == null || this.getClass().equals(adapter.getClass())) {
                throw new IOException(String.format("Serialization of discriminator base class %s is not supported", value.getClass().getName()));
            }
            LOGGER.log(Level.FINEST, "Delegating serialization to adapter for runtime type: {0}", value.getClass().getName());
            adapter.write(out, value);
        }

        @Override
        public T read(JsonReader in) throws IOException {
            LOGGER.log(Level.FINEST, "Deserializing JSON object for discriminator class: {0}", this.discMetadata.getDiscriminatorClass().getName());
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                JsonElement parseTree = JsonParser.parseReader(in);
                LOGGER.log(Level.FINEST, "Parsed JSON into JsonElement tree: {0}", parseTree.toString());
                Class<T> deserTargetClass = this.getDeserTargetClass(parseTree);
                LOGGER.log(Level.FINEST, "Deserialization target class: {0}", deserTargetClass.getName());
                T instance = this.gson.fromJson(parseTree, deserTargetClass);
                return instance;
            }
            catch (Throwable t) {
                throw new IOException("The following error occurred while deserializing JSON object into discriminator class: " + this.discMetadata.getDiscriminatorClass().getName(), t);
            }
        }

        private Class<? extends T> getDeserTargetClass(JsonElement jsonTree) throws IOException {
            if (!jsonTree.isJsonObject()) {
                throw new IOException("Parsed JSON is expected to be a JSON Object");
            }
            JsonObject jsonRoot = jsonTree.getAsJsonObject();
            JsonElement discProperty = jsonRoot.get(this.discMetadata.getPropertyName());
            if (discProperty == null) {
                throw new IOException("Required discriminator property '" + this.discMetadata.getPropertyName() + "' not found in JSON object");
            }
            String discValue = discProperty.getAsString();
            if (StringUtils.isEmpty(discValue)) {
                throw new IOException("Unable to retrieve discriminator value for property '" + this.discMetadata.getPropertyName() + "'");
            }
            Class<?> deserTargetClass = this.discMetadata.getSubclassMapping(discValue);
            if (deserTargetClass == null) {
                String deserTargetName = this.discMetadata.getDiscriminatorClass().getPackage().getName() + "." + discValue;
                LOGGER.log(Level.FINEST, "Explicit discriminator mapping not found for value: {0}", discValue);
                try {
                    deserTargetClass = Class.forName(deserTargetName);
                    LOGGER.log(Level.FINEST, "Found implicit deserialization target class: {0}", deserTargetName);
                }
                catch (Throwable t) {
                    throw new IOException("Unable to determine implicit deserialization target class for discriminator value: " + discValue);
                }
            }
            return deserTargetClass;
        }
    }

    static class DiscriminatorMetadata {
        private Class<?> discriminatorClass;
        private String propertyName;
        private Map<String, Class<?>> mapping;

        DiscriminatorMetadata(Class<?> discriminatorClass, String propertyName, Map<String, Class<?>> mapping) {
            this.discriminatorClass = discriminatorClass;
            this.propertyName = propertyName;
            this.mapping = mapping;
        }

        Class<?> getDiscriminatorClass() {
            return this.discriminatorClass;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        Class<?> getSubclassMapping(String discriminatorValue) {
            return this.mapping != null ? this.mapping.get(discriminatorValue) : null;
        }
    }
}

