/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v1;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.code_engine.code_engine.v1.model.ProjectConfigGetOptions;
import com.ibm.cloud.code_engine.code_engine.v1.model.V1ProjectKubeConfig;
import com.ibm.cloud.code_engine.common.SdkCommon;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class CodeEngine
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "code_engine";
    public static final String DEFAULT_SERVICE_URL = "https://api.au-syd.codeengine.cloud.ibm.com/api/v1";

    public static CodeEngine newInstance() {
        return CodeEngine.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static CodeEngine newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator(serviceName);
        CodeEngine service = new CodeEngine(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public CodeEngine(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<V1ProjectKubeConfig> projectConfigGet(ProjectConfigGetOptions projectConfigGetOptions) {
        Validator.notNull(projectConfigGetOptions, "projectConfigGetOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_guid", projectConfigGetOptions.projectGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/api/v1/project/{project_guid}/config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "projectConfigGet");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("X-Delegated-Refresh-Token", projectConfigGetOptions.xDelegatedRefreshToken());
        if (projectConfigGetOptions.endpoint() != null) {
            builder.query("endpoint", String.valueOf(projectConfigGetOptions.endpoint()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<V1ProjectKubeConfig>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

