/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.App;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppPatch;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevision;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevisionsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.Binding;
import com.ibm.cloud.code_engine.code_engine.v2.model.BindingsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.Build;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildPatch;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRunsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.ComponentRef;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMap;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMapsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteAppRevisionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMapping;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMappingPatch;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMappingsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetAppRevisionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectEgressIpsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectStatusDetailsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Job;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobPatch;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRunsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppRevisionsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBindingsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBuildRunsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBuildsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListConfigMapsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListDomainMappingsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobRunsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListProjectsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListSecretsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Project;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectEgressIPAddresses;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectStatusDetails;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.ReplaceConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ReplaceSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Secret;
import com.ibm.cloud.code_engine.code_engine.v2.model.SecretsPager;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateJobOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEngineExamples {
    private static final Logger logger = LoggerFactory.getLogger(CodeEngineExamples.class);

    protected CodeEngineExamples() {
    }

    public static void main(String[] args2) throws Exception {
        Secret secret;
        ConfigMap configMap;
        BuildRun buildRun;
        Build build;
        Response<GenericModel> response;
        ComponentRef componentRefModel;
        JobRun jobRun;
        Job job;
        Response<GenericModel> response2;
        App app;
        Project project;
        Response<Object> response3;
        List<GenericModel> nextPage;
        ArrayList<Project> allResults;
        Object pager;
        CodeEngine codeEngineService = CodeEngine.newInstance();
        Map<String, String> testConfigProperties = CredentialUtils.getServiceProperties("code_engine");
        try {
            System.out.println("listProjects() result:");
            ListProjectsOptions listProjectsOptions = new ListProjectsOptions.Builder().limit(Long.valueOf("100")).build();
            pager = new ProjectsPager(codeEngineService, listProjectsOptions);
            allResults = new ArrayList<Project>();
            while (((ProjectsPager)pager).hasNext()) {
                nextPage = ((ProjectsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createProject() result:");
            CreateProjectOptions createProjectOptions = new CreateProjectOptions.Builder().name("my-project").build();
            response3 = codeEngineService.createProject(createProjectOptions).execute();
            project = response3.getResult();
            System.out.println(project);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getProject() result:");
            GetProjectOptions getProjectOptions = new GetProjectOptions.Builder().id("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.getProject(getProjectOptions).execute();
            project = response3.getResult();
            System.out.println(project);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getProjectEgressIps() result:");
            GetProjectEgressIpsOptions getProjectEgressIpsOptions = new GetProjectEgressIpsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.getProjectEgressIps(getProjectEgressIpsOptions).execute();
            ProjectEgressIPAddresses projectEgressIpAddresses = (ProjectEgressIPAddresses)response3.getResult();
            System.out.println(projectEgressIpAddresses);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getProjectStatusDetails() result:");
            GetProjectStatusDetailsOptions getProjectStatusDetailsOptions = new GetProjectStatusDetailsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.getProjectStatusDetails(getProjectStatusDetailsOptions).execute();
            ProjectStatusDetails projectStatusDetails = (ProjectStatusDetails)response3.getResult();
            System.out.println(projectStatusDetails);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listApps() result:");
            ListAppsOptions listAppsOptions = new ListAppsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new AppsPager(codeEngineService, listAppsOptions);
            allResults = new ArrayList();
            while (((AppsPager)pager).hasNext()) {
                nextPage = ((AppsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createApp() result:");
            CreateAppOptions createAppOptions = new CreateAppOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").imageReference("icr.io/codeengine/helloworld").name("my-app").build();
            response3 = codeEngineService.createApp(createAppOptions).execute();
            app = (App)response3.getResult();
            System.out.println(app);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getApp() result:");
            GetAppOptions getAppOptions = new GetAppOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-app").build();
            response3 = codeEngineService.getApp(getAppOptions).execute();
            app = (App)response3.getResult();
            System.out.println(app);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updateApp() result:");
            AppPatch appPatchModel = new AppPatch.Builder().build();
            Map<String, Object> appPatchModelAsPatch = appPatchModel.asPatch();
            UpdateAppOptions updateAppOptions = new UpdateAppOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-app").ifMatch("testString").app(appPatchModelAsPatch).build();
            response2 = codeEngineService.updateApp(updateAppOptions).execute();
            App app2 = response2.getResult();
            System.out.println(app2);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listAppRevisions() result:");
            ListAppRevisionsOptions listAppRevisionsOptions = new ListAppRevisionsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").appName("my-app").limit(Long.valueOf("100")).build();
            pager = new AppRevisionsPager(codeEngineService, listAppRevisionsOptions);
            allResults = new ArrayList();
            while (((AppRevisionsPager)pager).hasNext()) {
                nextPage = ((AppRevisionsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getAppRevision() result:");
            GetAppRevisionOptions getAppRevisionOptions = new GetAppRevisionOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").appName("my-app").name("my-app-00001").build();
            response3 = codeEngineService.getAppRevision(getAppRevisionOptions).execute();
            AppRevision appRevision = (AppRevision)response3.getResult();
            System.out.println(appRevision);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listJobs() result:");
            ListJobsOptions listJobsOptions = new ListJobsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new JobsPager(codeEngineService, listJobsOptions);
            allResults = new ArrayList();
            while (((JobsPager)pager).hasNext()) {
                nextPage = ((JobsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createJob() result:");
            CreateJobOptions createJobOptions = new CreateJobOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").imageReference("icr.io/codeengine/helloworld").name("my-job").build();
            response3 = codeEngineService.createJob(createJobOptions).execute();
            job = (Job)response3.getResult();
            System.out.println(job);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getJob() result:");
            GetJobOptions getJobOptions = new GetJobOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-job").build();
            response3 = codeEngineService.getJob(getJobOptions).execute();
            job = (Job)response3.getResult();
            System.out.println(job);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updateJob() result:");
            JobPatch jobPatchModel = new JobPatch.Builder().build();
            Map<String, Object> jobPatchModelAsPatch = jobPatchModel.asPatch();
            UpdateJobOptions updateJobOptions = new UpdateJobOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-job").ifMatch("testString").job(jobPatchModelAsPatch).build();
            response2 = codeEngineService.updateJob(updateJobOptions).execute();
            Job job2 = (Job)response2.getResult();
            System.out.println(job2);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listJobRuns() result:");
            ListJobRunsOptions listJobRunsOptions = new ListJobRunsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").jobName("my-job").limit(Long.valueOf("100")).build();
            pager = new JobRunsPager(codeEngineService, listJobRunsOptions);
            allResults = new ArrayList();
            while (((JobRunsPager)pager).hasNext()) {
                nextPage = ((JobRunsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createJobRun() result:");
            CreateJobRunOptions createJobRunOptions = new CreateJobRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.createJobRun(createJobRunOptions).execute();
            jobRun = (JobRun)response3.getResult();
            System.out.println(jobRun);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getJobRun() result:");
            GetJobRunOptions getJobRunOptions = new GetJobRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-job-run").build();
            response3 = codeEngineService.getJobRun(getJobRunOptions).execute();
            jobRun = (JobRun)response3.getResult();
            System.out.println(jobRun);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listBindings() result:");
            ListBindingsOptions listBindingsOptions = new ListBindingsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new BindingsPager(codeEngineService, listBindingsOptions);
            allResults = new ArrayList();
            while (((BindingsPager)pager).hasNext()) {
                nextPage = ((BindingsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createBinding() result:");
            componentRefModel = new ComponentRef.Builder().name("my-app-1").resourceType("app_v2").build();
            CreateBindingOptions createBindingOptions = new CreateBindingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").component(componentRefModel).prefix("MY_COS").secretName("my-service-access").build();
            response = codeEngineService.createBinding(createBindingOptions).execute();
            Binding binding = response.getResult();
            System.out.println(binding);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getBinding() result:");
            GetBindingOptions getBindingOptions = new GetBindingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").id("a172ced-b5f21bc-71ba50c-1638604").build();
            response3 = codeEngineService.getBinding(getBindingOptions).execute();
            Binding binding = (Binding)response3.getResult();
            System.out.println(binding);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listBuilds() result:");
            ListBuildsOptions listBuildsOptions = new ListBuildsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new BuildsPager(codeEngineService, listBuildsOptions);
            allResults = new ArrayList();
            while (((BuildsPager)pager).hasNext()) {
                nextPage = ((BuildsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createBuild() result:");
            CreateBuildOptions createBuildOptions = new CreateBuildOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build").outputImage("private.de.icr.io/icr_namespace/image-name").outputSecret("ce-auto-icr-private-eu-de").strategyType("dockerfile").build();
            response3 = codeEngineService.createBuild(createBuildOptions).execute();
            build = (Build)response3.getResult();
            System.out.println(build);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getBuild() result:");
            GetBuildOptions getBuildOptions = new GetBuildOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build").build();
            response3 = codeEngineService.getBuild(getBuildOptions).execute();
            build = (Build)response3.getResult();
            System.out.println(build);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updateBuild() result:");
            BuildPatch buildPatchModel = new BuildPatch.Builder().build();
            Map<String, Object> buildPatchModelAsPatch = buildPatchModel.asPatch();
            UpdateBuildOptions updateBuildOptions = new UpdateBuildOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build").ifMatch("testString").build(buildPatchModelAsPatch).build();
            response2 = codeEngineService.updateBuild(updateBuildOptions).execute();
            Build build2 = (Build)response2.getResult();
            System.out.println(build2);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listBuildRuns() result:");
            ListBuildRunsOptions listBuildRunsOptions = new ListBuildRunsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").buildName("my-build").limit(Long.valueOf("100")).build();
            pager = new BuildRunsPager(codeEngineService, listBuildRunsOptions);
            allResults = new ArrayList();
            while (((BuildRunsPager)pager).hasNext()) {
                nextPage = ((BuildRunsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createBuildRun() result:");
            CreateBuildRunOptions createBuildRunOptions = new CreateBuildRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.createBuildRun(createBuildRunOptions).execute();
            buildRun = (BuildRun)response3.getResult();
            System.out.println(buildRun);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getBuildRun() result:");
            GetBuildRunOptions getBuildRunOptions = new GetBuildRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build-run").build();
            response3 = codeEngineService.getBuildRun(getBuildRunOptions).execute();
            buildRun = (BuildRun)response3.getResult();
            System.out.println(buildRun);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listConfigMaps() result:");
            ListConfigMapsOptions listConfigMapsOptions = new ListConfigMapsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new ConfigMapsPager(codeEngineService, listConfigMapsOptions);
            allResults = new ArrayList();
            while (((ConfigMapsPager)pager).hasNext()) {
                nextPage = ((ConfigMapsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createConfigMap() result:");
            CreateConfigMapOptions createConfigMapOptions = new CreateConfigMapOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-config-map").build();
            response3 = codeEngineService.createConfigMap(createConfigMapOptions).execute();
            configMap = (ConfigMap)response3.getResult();
            System.out.println(configMap);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getConfigMap() result:");
            GetConfigMapOptions getConfigMapOptions = new GetConfigMapOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-config-map").build();
            response3 = codeEngineService.getConfigMap(getConfigMapOptions).execute();
            configMap = (ConfigMap)response3.getResult();
            System.out.println(configMap);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("replaceConfigMap() result:");
            ReplaceConfigMapOptions replaceConfigMapOptions = new ReplaceConfigMapOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-config-map").ifMatch("testString").build();
            response3 = codeEngineService.replaceConfigMap(replaceConfigMapOptions).execute();
            configMap = (ConfigMap)response3.getResult();
            System.out.println(configMap);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listSecrets() result:");
            ListSecretsOptions listSecretsOptions = new ListSecretsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new SecretsPager(codeEngineService, listSecretsOptions);
            allResults = new ArrayList();
            while (((SecretsPager)pager).hasNext()) {
                nextPage = ((SecretsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createSecret() result:");
            CreateSecretOptions createSecretOptions = new CreateSecretOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").format("generic").name("my-secret").build();
            response3 = codeEngineService.createSecret(createSecretOptions).execute();
            secret = (Secret)response3.getResult();
            System.out.println(secret);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getSecret() result:");
            GetSecretOptions getSecretOptions = new GetSecretOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-secret").build();
            response3 = codeEngineService.getSecret(getSecretOptions).execute();
            secret = (Secret)response3.getResult();
            System.out.println(secret);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("replaceSecret() result:");
            ReplaceSecretOptions replaceSecretOptions = new ReplaceSecretOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-secret").ifMatch("testString").format("generic").build();
            response3 = codeEngineService.replaceSecret(replaceSecretOptions).execute();
            secret = (Secret)response3.getResult();
            System.out.println(secret);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listDomainMappings() result:");
            ListDomainMappingsOptions listDomainMappingsOptions = new ListDomainMappingsOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").limit(Long.valueOf("100")).build();
            pager = new DomainMappingsPager(codeEngineService, listDomainMappingsOptions);
            allResults = new ArrayList();
            while (((DomainMappingsPager)pager).hasNext()) {
                nextPage = ((DomainMappingsPager)pager).getNext();
                allResults.addAll(nextPage);
            }
            System.out.println(GsonSingleton.getGson().toJson(allResults));
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createDomainMapping() result:");
            componentRefModel = new ComponentRef.Builder().name("my-app-1").resourceType("app_v2").build();
            CreateDomainMappingOptions createDomainMappingOptions = new CreateDomainMappingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").component(componentRefModel).name("www.example.com").tlsSecret("my-tls-secret").build();
            response = codeEngineService.createDomainMapping(createDomainMappingOptions).execute();
            DomainMapping domainMapping = (DomainMapping)response.getResult();
            System.out.println(domainMapping);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getDomainMapping() result:");
            GetDomainMappingOptions getDomainMappingOptions = new GetDomainMappingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("www.example.com").build();
            response3 = codeEngineService.getDomainMapping(getDomainMappingOptions).execute();
            DomainMapping domainMapping = (DomainMapping)response3.getResult();
            System.out.println(domainMapping);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updateDomainMapping() result:");
            DomainMappingPatch domainMappingPatchModel = new DomainMappingPatch.Builder().build();
            Map<String, Object> domainMappingPatchModelAsPatch = domainMappingPatchModel.asPatch();
            UpdateDomainMappingOptions updateDomainMappingOptions = new UpdateDomainMappingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("www.example.com").ifMatch("testString").domainMapping(domainMappingPatchModelAsPatch).build();
            response2 = codeEngineService.updateDomainMapping(updateDomainMappingOptions).execute();
            DomainMapping domainMapping = (DomainMapping)response2.getResult();
            System.out.println(domainMapping);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteProjectOptions deleteProjectOptions = new DeleteProjectOptions.Builder().id("15314cc3-85b4-4338-903f-c28cdee6d005").build();
            response3 = codeEngineService.deleteProject(deleteProjectOptions).execute();
            System.out.printf("deleteProject() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteAppOptions deleteAppOptions = new DeleteAppOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-app").build();
            response3 = codeEngineService.deleteApp(deleteAppOptions).execute();
            System.out.printf("deleteApp() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteAppRevisionOptions deleteAppRevisionOptions = new DeleteAppRevisionOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").appName("my-app").name("my-app-00001").build();
            response3 = codeEngineService.deleteAppRevision(deleteAppRevisionOptions).execute();
            System.out.printf("deleteAppRevision() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteJobOptions deleteJobOptions = new DeleteJobOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-job").build();
            response3 = codeEngineService.deleteJob(deleteJobOptions).execute();
            System.out.printf("deleteJob() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteJobRunOptions deleteJobRunOptions = new DeleteJobRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-job-run").build();
            response3 = codeEngineService.deleteJobRun(deleteJobRunOptions).execute();
            System.out.printf("deleteJobRun() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteBindingOptions deleteBindingOptions = new DeleteBindingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").id("a172ced-b5f21bc-71ba50c-1638604").build();
            response3 = codeEngineService.deleteBinding(deleteBindingOptions).execute();
            System.out.printf("deleteBinding() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteBuildOptions deleteBuildOptions = new DeleteBuildOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build").build();
            response3 = codeEngineService.deleteBuild(deleteBuildOptions).execute();
            System.out.printf("deleteBuild() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteBuildRunOptions deleteBuildRunOptions = new DeleteBuildRunOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-build-run").build();
            response3 = codeEngineService.deleteBuildRun(deleteBuildRunOptions).execute();
            System.out.printf("deleteBuildRun() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteConfigMapOptions deleteConfigMapOptions = new DeleteConfigMapOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-config-map").build();
            response3 = codeEngineService.deleteConfigMap(deleteConfigMapOptions).execute();
            System.out.printf("deleteConfigMap() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteSecretOptions deleteSecretOptions = new DeleteSecretOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("my-secret").build();
            response3 = codeEngineService.deleteSecret(deleteSecretOptions).execute();
            System.out.printf("deleteSecret() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteDomainMappingOptions deleteDomainMappingOptions = new DeleteDomainMappingOptions.Builder().projectId("15314cc3-85b4-4338-903f-c28cdee6d005").name("www.example.com").build();
            response3 = codeEngineService.deleteDomainMapping(deleteDomainMappingOptions).execute();
            System.out.printf("deleteDomainMapping() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
    }

    static {
        System.setProperty("IBM_CREDENTIALS_FILE", "../../code_engine_v2.env");
    }
}

