/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.ibm.cloud.sdk.core.service.model.ObjectModel;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;

public final class ResponseUtils {
    private static final String ERROR_MESSAGE = "Error reading the http response";
    private static final Logger LOG = Logger.getLogger(ResponseUtils.class.getName());

    private ResponseUtils() {
    }

    public static InputStream getInputStream(Response response) {
        return response.body().byteStream();
    }

    public static JsonElement getJsonElement(Response response) {
        return new JsonParser().parse(response.body().charStream());
    }

    public static JsonObject getJsonObject(Response response) {
        return ResponseUtils.getJsonElement(response).getAsJsonObject();
    }

    public static JsonObject getJsonObject(String jsonString) {
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ObjectModel> T getObject(Response response, Class<? extends T> type) {
        try {
            JsonReader reader = new JsonReader(response.body().charStream());
            ObjectModel objectModel = (ObjectModel)GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(reader, type);
            return (T)objectModel;
        }
        finally {
            response.body().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getObject(Response response, Type type) {
        try {
            JsonReader reader = new JsonReader(response.body().charStream());
            Object t = GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(reader, type);
            return t;
        }
        finally {
            response.body().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getValue(Response response, Class<? extends T> valueType) {
        try {
            JsonReader reader = new JsonReader(response.body().charStream());
            Object t = GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(reader, valueType);
            return t;
        }
        finally {
            response.body().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getValue(Response response, Type valueType) {
        try {
            JsonReader reader = new JsonReader(response.body().charStream());
            Object t = GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(reader, valueType);
            return t;
        }
        finally {
            response.body().close();
        }
    }

    public static String getString(Response response) {
        try {
            return response.body().string();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, ERROR_MESSAGE, e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }
}

