/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v1;

import com.ibm.cloud.code_engine.code_engine.v1.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v1.model.ProjectConfigGetOptions;
import com.ibm.cloud.code_engine.code_engine.v1.model.V1ProjectKubeConfig;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEngineExamples {
    private static final Logger logger = LoggerFactory.getLogger(CodeEngineExamples.class);

    protected CodeEngineExamples() {
    }

    public static void main(String[] args2) throws Exception {
        CodeEngine codeEngineService = CodeEngine.newInstance();
        Map<String, String> testConfigProperties = CredentialUtils.getServiceProperties("code_engine");
        try {
            System.out.println("projectConfigGet() result:");
            ProjectConfigGetOptions projectConfigGetOptions = new ProjectConfigGetOptions.Builder().xDelegatedRefreshToken("testString").projectGuid("testString").build();
            Response<V1ProjectKubeConfig> response = codeEngineService.projectConfigGet(projectConfigGetOptions).execute();
            V1ProjectKubeConfig v1ProjectKubeConfig = response.getResult();
            System.out.println(v1ProjectKubeConfig);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
    }

    static {
        System.setProperty("IBM_CREDENTIALS_FILE", "../../code_engine_v1.env");
    }
}

