/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.code_engine.code_engine.v2.model.AllowedOutboundDestination;
import com.ibm.cloud.code_engine.code_engine.v2.model.AllowedOutboundDestinationList;
import com.ibm.cloud.code_engine.code_engine.v2.model.App;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppInstanceList;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppList;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevision;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevisionList;
import com.ibm.cloud.code_engine.code_engine.v2.model.Binding;
import com.ibm.cloud.code_engine.code_engine.v2.model.BindingList;
import com.ibm.cloud.code_engine.code_engine.v2.model.Build;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildList;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRunList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMap;
import com.ibm.cloud.code_engine.code_engine.v2.model.ConfigMapList;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateAllowedOutboundDestinationOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateFunctionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.CreateSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteAllowedOutboundDestinationOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteAppRevisionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteFunctionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DeleteSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMapping;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMappingList;
import com.ibm.cloud.code_engine.code_engine.v2.model.Function;
import com.ibm.cloud.code_engine.code_engine.v2.model.FunctionList;
import com.ibm.cloud.code_engine.code_engine.v2.model.FunctionRuntimeList;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetAllowedOutboundDestinationOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetAppRevisionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBindingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetBuildRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetFunctionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetJobOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetJobRunOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectEgressIpsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetProjectStatusDetailsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.GetSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Job;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobList;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRunList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAllowedOutboundDestinationOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppInstancesOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppRevisionsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBindingsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBuildRunsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBuildsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListConfigMapsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListDomainMappingsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListFunctionRuntimesOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListFunctionsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobRunsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListProjectsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListSecretsOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Project;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectEgressIPAddresses;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ProjectStatusDetails;
import com.ibm.cloud.code_engine.code_engine.v2.model.ReplaceConfigMapOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.ReplaceSecretOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.Secret;
import com.ibm.cloud.code_engine.code_engine.v2.model.SecretList;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateAllowedOutboundDestinationOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateAppOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateBuildOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateDomainMappingOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateFunctionOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.UpdateJobOptions;
import com.ibm.cloud.code_engine.common.SdkCommon;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class CodeEngine
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "code_engine";
    public static final String DEFAULT_SERVICE_URL = "https://api.au-syd.codeengine.cloud.ibm.com/v2";
    private String version;

    public static CodeEngine newInstance() {
        return CodeEngine.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static CodeEngine newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator(serviceName);
        CodeEngine service = new CodeEngine(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public CodeEngine(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceCall<ProjectList> listProjects(ListProjectsOptions listProjectsOptions) {
        if (listProjectsOptions == null) {
            listProjectsOptions = new ListProjectsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listProjects");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listProjectsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listProjectsOptions.limit()));
        }
        if (listProjectsOptions.start() != null) {
            builder.query("start", String.valueOf(listProjectsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ProjectList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProjectList> listProjects() {
        return this.listProjects(null);
    }

    public ServiceCall<Project> createProject(CreateProjectOptions createProjectOptions) {
        Validator.notNull(createProjectOptions, "createProjectOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createProject");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createProjectOptions.name());
        if (createProjectOptions.resourceGroupId() != null) {
            contentJson.addProperty("resource_group_id", createProjectOptions.resourceGroupId());
        }
        if (createProjectOptions.tags() != null) {
            contentJson.add("tags", GsonSingleton.getGson().toJsonTree(createProjectOptions.tags()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Project>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Project> getProject(GetProjectOptions getProjectOptions) {
        Validator.notNull(getProjectOptions, "getProjectOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getProjectOptions.id());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getProject");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Project>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteProject(DeleteProjectOptions deleteProjectOptions) {
        Validator.notNull(deleteProjectOptions, "deleteProjectOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteProjectOptions.id());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteProject");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllowedOutboundDestinationList> listAllowedOutboundDestination(ListAllowedOutboundDestinationOptions listAllowedOutboundDestinationOptions) {
        Validator.notNull(listAllowedOutboundDestinationOptions, "listAllowedOutboundDestinationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listAllowedOutboundDestinationOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/allowed_outbound_destinations", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listAllowedOutboundDestination");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (listAllowedOutboundDestinationOptions.limit() != null) {
            builder.query("limit", String.valueOf(listAllowedOutboundDestinationOptions.limit()));
        }
        if (listAllowedOutboundDestinationOptions.start() != null) {
            builder.query("start", String.valueOf(listAllowedOutboundDestinationOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllowedOutboundDestinationList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllowedOutboundDestination> createAllowedOutboundDestination(CreateAllowedOutboundDestinationOptions createAllowedOutboundDestinationOptions) {
        Validator.notNull(createAllowedOutboundDestinationOptions, "createAllowedOutboundDestinationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createAllowedOutboundDestinationOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/allowed_outbound_destinations", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createAllowedOutboundDestination");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(createAllowedOutboundDestinationOptions.allowedOutboundDestination()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllowedOutboundDestination>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllowedOutboundDestination> getAllowedOutboundDestination(GetAllowedOutboundDestinationOptions getAllowedOutboundDestinationOptions) {
        Validator.notNull(getAllowedOutboundDestinationOptions, "getAllowedOutboundDestinationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getAllowedOutboundDestinationOptions.projectId());
        pathParamsMap.put("name", getAllowedOutboundDestinationOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/allowed_outbound_destinations/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAllowedOutboundDestination");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllowedOutboundDestination>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteAllowedOutboundDestination(DeleteAllowedOutboundDestinationOptions deleteAllowedOutboundDestinationOptions) {
        Validator.notNull(deleteAllowedOutboundDestinationOptions, "deleteAllowedOutboundDestinationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteAllowedOutboundDestinationOptions.projectId());
        pathParamsMap.put("name", deleteAllowedOutboundDestinationOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/allowed_outbound_destinations/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteAllowedOutboundDestination");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllowedOutboundDestination> updateAllowedOutboundDestination(UpdateAllowedOutboundDestinationOptions updateAllowedOutboundDestinationOptions) {
        Validator.notNull(updateAllowedOutboundDestinationOptions, "updateAllowedOutboundDestinationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateAllowedOutboundDestinationOptions.projectId());
        pathParamsMap.put("name", updateAllowedOutboundDestinationOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/allowed_outbound_destinations/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateAllowedOutboundDestination");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateAllowedOutboundDestinationOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateAllowedOutboundDestinationOptions.allowedOutboundDestination()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllowedOutboundDestination>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProjectEgressIPAddresses> getProjectEgressIps(GetProjectEgressIpsOptions getProjectEgressIpsOptions) {
        Validator.notNull(getProjectEgressIpsOptions, "getProjectEgressIpsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getProjectEgressIpsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/egress_ips", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getProjectEgressIps");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ProjectEgressIPAddresses>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProjectStatusDetails> getProjectStatusDetails(GetProjectStatusDetailsOptions getProjectStatusDetailsOptions) {
        Validator.notNull(getProjectStatusDetailsOptions, "getProjectStatusDetailsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getProjectStatusDetailsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/status_details", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getProjectStatusDetails");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ProjectStatusDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AppList> listApps(ListAppsOptions listAppsOptions) {
        Validator.notNull(listAppsOptions, "listAppsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listAppsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listApps");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listAppsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listAppsOptions.limit()));
        }
        if (listAppsOptions.start() != null) {
            builder.query("start", String.valueOf(listAppsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AppList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<App> createApp(CreateAppOptions createAppOptions) {
        Validator.notNull(createAppOptions, "createAppOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createAppOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createApp");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("image_reference", createAppOptions.imageReference());
        contentJson.addProperty("name", createAppOptions.name());
        if (createAppOptions.imagePort() != null) {
            contentJson.addProperty("image_port", createAppOptions.imagePort());
        }
        if (createAppOptions.imageSecret() != null) {
            contentJson.addProperty("image_secret", createAppOptions.imageSecret());
        }
        if (createAppOptions.managedDomainMappings() != null) {
            contentJson.addProperty("managed_domain_mappings", createAppOptions.managedDomainMappings());
        }
        if (createAppOptions.probeLiveness() != null) {
            contentJson.add("probe_liveness", GsonSingleton.getGson().toJsonTree(createAppOptions.probeLiveness()));
        }
        if (createAppOptions.probeReadiness() != null) {
            contentJson.add("probe_readiness", GsonSingleton.getGson().toJsonTree(createAppOptions.probeReadiness()));
        }
        if (createAppOptions.runArguments() != null) {
            contentJson.add("run_arguments", GsonSingleton.getGson().toJsonTree(createAppOptions.runArguments()));
        }
        if (createAppOptions.runAsUser() != null) {
            contentJson.addProperty("run_as_user", createAppOptions.runAsUser());
        }
        if (createAppOptions.runCommands() != null) {
            contentJson.add("run_commands", GsonSingleton.getGson().toJsonTree(createAppOptions.runCommands()));
        }
        if (createAppOptions.runComputeResourceTokenEnabled() != null) {
            contentJson.addProperty("run_compute_resource_token_enabled", createAppOptions.runComputeResourceTokenEnabled());
        }
        if (createAppOptions.runEnvVariables() != null) {
            contentJson.add("run_env_variables", GsonSingleton.getGson().toJsonTree(createAppOptions.runEnvVariables()));
        }
        if (createAppOptions.runServiceAccount() != null) {
            contentJson.addProperty("run_service_account", createAppOptions.runServiceAccount());
        }
        if (createAppOptions.runVolumeMounts() != null) {
            contentJson.add("run_volume_mounts", GsonSingleton.getGson().toJsonTree(createAppOptions.runVolumeMounts()));
        }
        if (createAppOptions.scaleConcurrency() != null) {
            contentJson.addProperty("scale_concurrency", createAppOptions.scaleConcurrency());
        }
        if (createAppOptions.scaleConcurrencyTarget() != null) {
            contentJson.addProperty("scale_concurrency_target", createAppOptions.scaleConcurrencyTarget());
        }
        if (createAppOptions.scaleCpuLimit() != null) {
            contentJson.addProperty("scale_cpu_limit", createAppOptions.scaleCpuLimit());
        }
        if (createAppOptions.scaleDownDelay() != null) {
            contentJson.addProperty("scale_down_delay", createAppOptions.scaleDownDelay());
        }
        if (createAppOptions.scaleEphemeralStorageLimit() != null) {
            contentJson.addProperty("scale_ephemeral_storage_limit", createAppOptions.scaleEphemeralStorageLimit());
        }
        if (createAppOptions.scaleInitialInstances() != null) {
            contentJson.addProperty("scale_initial_instances", createAppOptions.scaleInitialInstances());
        }
        if (createAppOptions.scaleMaxInstances() != null) {
            contentJson.addProperty("scale_max_instances", createAppOptions.scaleMaxInstances());
        }
        if (createAppOptions.scaleMemoryLimit() != null) {
            contentJson.addProperty("scale_memory_limit", createAppOptions.scaleMemoryLimit());
        }
        if (createAppOptions.scaleMinInstances() != null) {
            contentJson.addProperty("scale_min_instances", createAppOptions.scaleMinInstances());
        }
        if (createAppOptions.scaleRequestTimeout() != null) {
            contentJson.addProperty("scale_request_timeout", createAppOptions.scaleRequestTimeout());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<App>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<App> getApp(GetAppOptions getAppOptions) {
        Validator.notNull(getAppOptions, "getAppOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getAppOptions.projectId());
        pathParamsMap.put("name", getAppOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getApp");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<App>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteApp(DeleteAppOptions deleteAppOptions) {
        Validator.notNull(deleteAppOptions, "deleteAppOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteAppOptions.projectId());
        pathParamsMap.put("name", deleteAppOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteApp");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (deleteAppOptions.keepServiceAccess() != null) {
            builder.query("keep_service_access", String.valueOf(deleteAppOptions.keepServiceAccess()));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<App> updateApp(UpdateAppOptions updateAppOptions) {
        Validator.notNull(updateAppOptions, "updateAppOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateAppOptions.projectId());
        pathParamsMap.put("name", updateAppOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateApp");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateAppOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateAppOptions.app()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<App>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AppRevisionList> listAppRevisions(ListAppRevisionsOptions listAppRevisionsOptions) {
        Validator.notNull(listAppRevisionsOptions, "listAppRevisionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listAppRevisionsOptions.projectId());
        pathParamsMap.put("app_name", listAppRevisionsOptions.appName());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{app_name}/revisions", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listAppRevisions");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (listAppRevisionsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listAppRevisionsOptions.limit()));
        }
        if (listAppRevisionsOptions.start() != null) {
            builder.query("start", String.valueOf(listAppRevisionsOptions.start()));
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AppRevisionList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AppRevision> getAppRevision(GetAppRevisionOptions getAppRevisionOptions) {
        Validator.notNull(getAppRevisionOptions, "getAppRevisionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getAppRevisionOptions.projectId());
        pathParamsMap.put("app_name", getAppRevisionOptions.appName());
        pathParamsMap.put("name", getAppRevisionOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{app_name}/revisions/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAppRevision");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AppRevision>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteAppRevision(DeleteAppRevisionOptions deleteAppRevisionOptions) {
        Validator.notNull(deleteAppRevisionOptions, "deleteAppRevisionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteAppRevisionOptions.projectId());
        pathParamsMap.put("app_name", deleteAppRevisionOptions.appName());
        pathParamsMap.put("name", deleteAppRevisionOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{app_name}/revisions/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteAppRevision");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AppInstanceList> listAppInstances(ListAppInstancesOptions listAppInstancesOptions) {
        Validator.notNull(listAppInstancesOptions, "listAppInstancesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listAppInstancesOptions.projectId());
        pathParamsMap.put("app_name", listAppInstancesOptions.appName());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/apps/{app_name}/instances", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listAppInstances");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (listAppInstancesOptions.limit() != null) {
            builder.query("limit", String.valueOf(listAppInstancesOptions.limit()));
        }
        if (listAppInstancesOptions.start() != null) {
            builder.query("start", String.valueOf(listAppInstancesOptions.start()));
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AppInstanceList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<JobList> listJobs(ListJobsOptions listJobsOptions) {
        Validator.notNull(listJobsOptions, "listJobsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listJobsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/jobs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listJobs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listJobsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listJobsOptions.limit()));
        }
        if (listJobsOptions.start() != null) {
            builder.query("start", String.valueOf(listJobsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<JobList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Job> createJob(CreateJobOptions createJobOptions) {
        Validator.notNull(createJobOptions, "createJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createJobOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/jobs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("image_reference", createJobOptions.imageReference());
        contentJson.addProperty("name", createJobOptions.name());
        if (createJobOptions.imageSecret() != null) {
            contentJson.addProperty("image_secret", createJobOptions.imageSecret());
        }
        if (createJobOptions.runArguments() != null) {
            contentJson.add("run_arguments", GsonSingleton.getGson().toJsonTree(createJobOptions.runArguments()));
        }
        if (createJobOptions.runAsUser() != null) {
            contentJson.addProperty("run_as_user", createJobOptions.runAsUser());
        }
        if (createJobOptions.runCommands() != null) {
            contentJson.add("run_commands", GsonSingleton.getGson().toJsonTree(createJobOptions.runCommands()));
        }
        if (createJobOptions.runComputeResourceTokenEnabled() != null) {
            contentJson.addProperty("run_compute_resource_token_enabled", createJobOptions.runComputeResourceTokenEnabled());
        }
        if (createJobOptions.runEnvVariables() != null) {
            contentJson.add("run_env_variables", GsonSingleton.getGson().toJsonTree(createJobOptions.runEnvVariables()));
        }
        if (createJobOptions.runMode() != null) {
            contentJson.addProperty("run_mode", createJobOptions.runMode());
        }
        if (createJobOptions.runServiceAccount() != null) {
            contentJson.addProperty("run_service_account", createJobOptions.runServiceAccount());
        }
        if (createJobOptions.runVolumeMounts() != null) {
            contentJson.add("run_volume_mounts", GsonSingleton.getGson().toJsonTree(createJobOptions.runVolumeMounts()));
        }
        if (createJobOptions.scaleArraySpec() != null) {
            contentJson.addProperty("scale_array_spec", createJobOptions.scaleArraySpec());
        }
        if (createJobOptions.scaleCpuLimit() != null) {
            contentJson.addProperty("scale_cpu_limit", createJobOptions.scaleCpuLimit());
        }
        if (createJobOptions.scaleEphemeralStorageLimit() != null) {
            contentJson.addProperty("scale_ephemeral_storage_limit", createJobOptions.scaleEphemeralStorageLimit());
        }
        if (createJobOptions.scaleMaxExecutionTime() != null) {
            contentJson.addProperty("scale_max_execution_time", createJobOptions.scaleMaxExecutionTime());
        }
        if (createJobOptions.scaleMemoryLimit() != null) {
            contentJson.addProperty("scale_memory_limit", createJobOptions.scaleMemoryLimit());
        }
        if (createJobOptions.scaleRetryLimit() != null) {
            contentJson.addProperty("scale_retry_limit", createJobOptions.scaleRetryLimit());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Job>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Job> getJob(GetJobOptions getJobOptions) {
        Validator.notNull(getJobOptions, "getJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getJobOptions.projectId());
        pathParamsMap.put("name", getJobOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/jobs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Job>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteJob(DeleteJobOptions deleteJobOptions) {
        Validator.notNull(deleteJobOptions, "deleteJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteJobOptions.projectId());
        pathParamsMap.put("name", deleteJobOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/jobs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (deleteJobOptions.keepServiceAccess() != null) {
            builder.query("keep_service_access", String.valueOf(deleteJobOptions.keepServiceAccess()));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Job> updateJob(UpdateJobOptions updateJobOptions) {
        Validator.notNull(updateJobOptions, "updateJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateJobOptions.projectId());
        pathParamsMap.put("name", updateJobOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/jobs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateJobOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateJobOptions.job()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Job>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<JobRunList> listJobRuns(ListJobRunsOptions listJobRunsOptions) {
        Validator.notNull(listJobRunsOptions, "listJobRunsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listJobRunsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/job_runs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listJobRuns");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listJobRunsOptions.jobName() != null) {
            builder.query("job_name", String.valueOf(listJobRunsOptions.jobName()));
        }
        if (listJobRunsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listJobRunsOptions.limit()));
        }
        if (listJobRunsOptions.start() != null) {
            builder.query("start", String.valueOf(listJobRunsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<JobRunList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<JobRun> createJobRun(CreateJobRunOptions createJobRunOptions) {
        Validator.notNull(createJobRunOptions, "createJobRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createJobRunOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/job_runs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createJobRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        if (createJobRunOptions.imageReference() != null) {
            contentJson.addProperty("image_reference", createJobRunOptions.imageReference());
        }
        if (createJobRunOptions.imageSecret() != null) {
            contentJson.addProperty("image_secret", createJobRunOptions.imageSecret());
        }
        if (createJobRunOptions.jobName() != null) {
            contentJson.addProperty("job_name", createJobRunOptions.jobName());
        }
        if (createJobRunOptions.name() != null) {
            contentJson.addProperty("name", createJobRunOptions.name());
        }
        if (createJobRunOptions.runArguments() != null) {
            contentJson.add("run_arguments", GsonSingleton.getGson().toJsonTree(createJobRunOptions.runArguments()));
        }
        if (createJobRunOptions.runAsUser() != null) {
            contentJson.addProperty("run_as_user", createJobRunOptions.runAsUser());
        }
        if (createJobRunOptions.runCommands() != null) {
            contentJson.add("run_commands", GsonSingleton.getGson().toJsonTree(createJobRunOptions.runCommands()));
        }
        if (createJobRunOptions.runComputeResourceTokenEnabled() != null) {
            contentJson.addProperty("run_compute_resource_token_enabled", createJobRunOptions.runComputeResourceTokenEnabled());
        }
        if (createJobRunOptions.runEnvVariables() != null) {
            contentJson.add("run_env_variables", GsonSingleton.getGson().toJsonTree(createJobRunOptions.runEnvVariables()));
        }
        if (createJobRunOptions.runMode() != null) {
            contentJson.addProperty("run_mode", createJobRunOptions.runMode());
        }
        if (createJobRunOptions.runServiceAccount() != null) {
            contentJson.addProperty("run_service_account", createJobRunOptions.runServiceAccount());
        }
        if (createJobRunOptions.runVolumeMounts() != null) {
            contentJson.add("run_volume_mounts", GsonSingleton.getGson().toJsonTree(createJobRunOptions.runVolumeMounts()));
        }
        if (createJobRunOptions.scaleArraySizeVariableOverride() != null) {
            contentJson.addProperty("scale_array_size_variable_override", createJobRunOptions.scaleArraySizeVariableOverride());
        }
        if (createJobRunOptions.scaleArraySpec() != null) {
            contentJson.addProperty("scale_array_spec", createJobRunOptions.scaleArraySpec());
        }
        if (createJobRunOptions.scaleCpuLimit() != null) {
            contentJson.addProperty("scale_cpu_limit", createJobRunOptions.scaleCpuLimit());
        }
        if (createJobRunOptions.scaleEphemeralStorageLimit() != null) {
            contentJson.addProperty("scale_ephemeral_storage_limit", createJobRunOptions.scaleEphemeralStorageLimit());
        }
        if (createJobRunOptions.scaleMaxExecutionTime() != null) {
            contentJson.addProperty("scale_max_execution_time", createJobRunOptions.scaleMaxExecutionTime());
        }
        if (createJobRunOptions.scaleMemoryLimit() != null) {
            contentJson.addProperty("scale_memory_limit", createJobRunOptions.scaleMemoryLimit());
        }
        if (createJobRunOptions.scaleRetryLimit() != null) {
            contentJson.addProperty("scale_retry_limit", createJobRunOptions.scaleRetryLimit());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<JobRun>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<JobRun> getJobRun(GetJobRunOptions getJobRunOptions) {
        Validator.notNull(getJobRunOptions, "getJobRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getJobRunOptions.projectId());
        pathParamsMap.put("name", getJobRunOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/job_runs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getJobRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<JobRun>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteJobRun(DeleteJobRunOptions deleteJobRunOptions) {
        Validator.notNull(deleteJobRunOptions, "deleteJobRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteJobRunOptions.projectId());
        pathParamsMap.put("name", deleteJobRunOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/job_runs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteJobRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FunctionRuntimeList> listFunctionRuntimes(ListFunctionRuntimesOptions listFunctionRuntimesOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/function_runtimes"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listFunctionRuntimes");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<FunctionRuntimeList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FunctionRuntimeList> listFunctionRuntimes() {
        return this.listFunctionRuntimes(null);
    }

    public ServiceCall<FunctionList> listFunctions(ListFunctionsOptions listFunctionsOptions) {
        Validator.notNull(listFunctionsOptions, "listFunctionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listFunctionsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/functions", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listFunctions");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listFunctionsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listFunctionsOptions.limit()));
        }
        if (listFunctionsOptions.start() != null) {
            builder.query("start", String.valueOf(listFunctionsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<FunctionList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Function> createFunction(CreateFunctionOptions createFunctionOptions) {
        Validator.notNull(createFunctionOptions, "createFunctionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createFunctionOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/functions", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createFunction");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("code_reference", createFunctionOptions.codeReference());
        contentJson.addProperty("name", createFunctionOptions.name());
        contentJson.addProperty("runtime", createFunctionOptions.runtime());
        if (createFunctionOptions.codeBinary() != null) {
            contentJson.addProperty("code_binary", createFunctionOptions.codeBinary());
        }
        if (createFunctionOptions.codeMain() != null) {
            contentJson.addProperty("code_main", createFunctionOptions.codeMain());
        }
        if (createFunctionOptions.codeSecret() != null) {
            contentJson.addProperty("code_secret", createFunctionOptions.codeSecret());
        }
        if (createFunctionOptions.managedDomainMappings() != null) {
            contentJson.addProperty("managed_domain_mappings", createFunctionOptions.managedDomainMappings());
        }
        if (createFunctionOptions.runComputeResourceTokenEnabled() != null) {
            contentJson.addProperty("run_compute_resource_token_enabled", createFunctionOptions.runComputeResourceTokenEnabled());
        }
        if (createFunctionOptions.runEnvVariables() != null) {
            contentJson.add("run_env_variables", GsonSingleton.getGson().toJsonTree(createFunctionOptions.runEnvVariables()));
        }
        if (createFunctionOptions.scaleConcurrency() != null) {
            contentJson.addProperty("scale_concurrency", createFunctionOptions.scaleConcurrency());
        }
        if (createFunctionOptions.scaleCpuLimit() != null) {
            contentJson.addProperty("scale_cpu_limit", createFunctionOptions.scaleCpuLimit());
        }
        if (createFunctionOptions.scaleDownDelay() != null) {
            contentJson.addProperty("scale_down_delay", createFunctionOptions.scaleDownDelay());
        }
        if (createFunctionOptions.scaleMaxExecutionTime() != null) {
            contentJson.addProperty("scale_max_execution_time", createFunctionOptions.scaleMaxExecutionTime());
        }
        if (createFunctionOptions.scaleMemoryLimit() != null) {
            contentJson.addProperty("scale_memory_limit", createFunctionOptions.scaleMemoryLimit());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Function>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Function> getFunction(GetFunctionOptions getFunctionOptions) {
        Validator.notNull(getFunctionOptions, "getFunctionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getFunctionOptions.projectId());
        pathParamsMap.put("name", getFunctionOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/functions/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getFunction");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Function>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteFunction(DeleteFunctionOptions deleteFunctionOptions) {
        Validator.notNull(deleteFunctionOptions, "deleteFunctionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteFunctionOptions.projectId());
        pathParamsMap.put("name", deleteFunctionOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/functions/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteFunction");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (deleteFunctionOptions.keepServiceAccess() != null) {
            builder.query("keep_service_access", String.valueOf(deleteFunctionOptions.keepServiceAccess()));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Function> updateFunction(UpdateFunctionOptions updateFunctionOptions) {
        Validator.notNull(updateFunctionOptions, "updateFunctionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateFunctionOptions.projectId());
        pathParamsMap.put("name", updateFunctionOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/functions/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateFunction");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateFunctionOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateFunctionOptions.function()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Function>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BindingList> listBindings(ListBindingsOptions listBindingsOptions) {
        Validator.notNull(listBindingsOptions, "listBindingsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listBindingsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/bindings", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listBindings");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listBindingsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listBindingsOptions.limit()));
        }
        if (listBindingsOptions.start() != null) {
            builder.query("start", String.valueOf(listBindingsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BindingList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Binding> createBinding(CreateBindingOptions createBindingOptions) {
        Validator.notNull(createBindingOptions, "createBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createBindingOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/bindings", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createBinding");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("component", GsonSingleton.getGson().toJsonTree(createBindingOptions.component()));
        contentJson.addProperty("prefix", createBindingOptions.prefix());
        contentJson.addProperty("secret_name", createBindingOptions.secretName());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Binding>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Binding> getBinding(GetBindingOptions getBindingOptions) {
        Validator.notNull(getBindingOptions, "getBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getBindingOptions.projectId());
        pathParamsMap.put("id", getBindingOptions.id());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/bindings/{id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getBinding");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Binding>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteBinding(DeleteBindingOptions deleteBindingOptions) {
        Validator.notNull(deleteBindingOptions, "deleteBindingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteBindingOptions.projectId());
        pathParamsMap.put("id", deleteBindingOptions.id());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/bindings/{id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteBinding");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BuildList> listBuilds(ListBuildsOptions listBuildsOptions) {
        Validator.notNull(listBuildsOptions, "listBuildsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listBuildsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/builds", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listBuilds");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listBuildsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listBuildsOptions.limit()));
        }
        if (listBuildsOptions.start() != null) {
            builder.query("start", String.valueOf(listBuildsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BuildList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Build> createBuild(CreateBuildOptions createBuildOptions) {
        Validator.notNull(createBuildOptions, "createBuildOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createBuildOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/builds", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createBuild");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createBuildOptions.name());
        contentJson.addProperty("output_image", createBuildOptions.outputImage());
        contentJson.addProperty("output_secret", createBuildOptions.outputSecret());
        contentJson.addProperty("strategy_type", createBuildOptions.strategyType());
        if (createBuildOptions.runBuildParams() != null) {
            contentJson.add("run_build_params", GsonSingleton.getGson().toJsonTree(createBuildOptions.runBuildParams()));
        }
        if (createBuildOptions.sourceContextDir() != null) {
            contentJson.addProperty("source_context_dir", createBuildOptions.sourceContextDir());
        }
        if (createBuildOptions.sourceRevision() != null) {
            contentJson.addProperty("source_revision", createBuildOptions.sourceRevision());
        }
        if (createBuildOptions.sourceSecret() != null) {
            contentJson.addProperty("source_secret", createBuildOptions.sourceSecret());
        }
        if (createBuildOptions.sourceType() != null) {
            contentJson.addProperty("source_type", createBuildOptions.sourceType());
        }
        if (createBuildOptions.sourceUrl() != null) {
            contentJson.addProperty("source_url", createBuildOptions.sourceUrl());
        }
        if (createBuildOptions.strategySize() != null) {
            contentJson.addProperty("strategy_size", createBuildOptions.strategySize());
        }
        if (createBuildOptions.strategySpecFile() != null) {
            contentJson.addProperty("strategy_spec_file", createBuildOptions.strategySpecFile());
        }
        if (createBuildOptions.timeout() != null) {
            contentJson.addProperty("timeout", createBuildOptions.timeout());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Build>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Build> getBuild(GetBuildOptions getBuildOptions) {
        Validator.notNull(getBuildOptions, "getBuildOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getBuildOptions.projectId());
        pathParamsMap.put("name", getBuildOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/builds/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getBuild");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Build>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteBuild(DeleteBuildOptions deleteBuildOptions) {
        Validator.notNull(deleteBuildOptions, "deleteBuildOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteBuildOptions.projectId());
        pathParamsMap.put("name", deleteBuildOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/builds/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteBuild");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Build> updateBuild(UpdateBuildOptions updateBuildOptions) {
        Validator.notNull(updateBuildOptions, "updateBuildOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateBuildOptions.projectId());
        pathParamsMap.put("name", updateBuildOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/builds/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateBuild");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateBuildOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateBuildOptions.build()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Build>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BuildRunList> listBuildRuns(ListBuildRunsOptions listBuildRunsOptions) {
        Validator.notNull(listBuildRunsOptions, "listBuildRunsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listBuildRunsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/build_runs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listBuildRuns");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listBuildRunsOptions.buildName() != null) {
            builder.query("build_name", String.valueOf(listBuildRunsOptions.buildName()));
        }
        if (listBuildRunsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listBuildRunsOptions.limit()));
        }
        if (listBuildRunsOptions.start() != null) {
            builder.query("start", String.valueOf(listBuildRunsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BuildRunList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BuildRun> createBuildRun(CreateBuildRunOptions createBuildRunOptions) {
        Validator.notNull(createBuildRunOptions, "createBuildRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createBuildRunOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/build_runs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createBuildRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        if (createBuildRunOptions.buildName() != null) {
            contentJson.addProperty("build_name", createBuildRunOptions.buildName());
        }
        if (createBuildRunOptions.name() != null) {
            contentJson.addProperty("name", createBuildRunOptions.name());
        }
        if (createBuildRunOptions.outputImage() != null) {
            contentJson.addProperty("output_image", createBuildRunOptions.outputImage());
        }
        if (createBuildRunOptions.outputSecret() != null) {
            contentJson.addProperty("output_secret", createBuildRunOptions.outputSecret());
        }
        if (createBuildRunOptions.runBuildParams() != null) {
            contentJson.add("run_build_params", GsonSingleton.getGson().toJsonTree(createBuildRunOptions.runBuildParams()));
        }
        if (createBuildRunOptions.serviceAccount() != null) {
            contentJson.addProperty("service_account", createBuildRunOptions.serviceAccount());
        }
        if (createBuildRunOptions.sourceContextDir() != null) {
            contentJson.addProperty("source_context_dir", createBuildRunOptions.sourceContextDir());
        }
        if (createBuildRunOptions.sourceRevision() != null) {
            contentJson.addProperty("source_revision", createBuildRunOptions.sourceRevision());
        }
        if (createBuildRunOptions.sourceSecret() != null) {
            contentJson.addProperty("source_secret", createBuildRunOptions.sourceSecret());
        }
        if (createBuildRunOptions.sourceType() != null) {
            contentJson.addProperty("source_type", createBuildRunOptions.sourceType());
        }
        if (createBuildRunOptions.sourceUrl() != null) {
            contentJson.addProperty("source_url", createBuildRunOptions.sourceUrl());
        }
        if (createBuildRunOptions.strategySize() != null) {
            contentJson.addProperty("strategy_size", createBuildRunOptions.strategySize());
        }
        if (createBuildRunOptions.strategySpecFile() != null) {
            contentJson.addProperty("strategy_spec_file", createBuildRunOptions.strategySpecFile());
        }
        if (createBuildRunOptions.strategyType() != null) {
            contentJson.addProperty("strategy_type", createBuildRunOptions.strategyType());
        }
        if (createBuildRunOptions.timeout() != null) {
            contentJson.addProperty("timeout", createBuildRunOptions.timeout());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BuildRun>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BuildRun> getBuildRun(GetBuildRunOptions getBuildRunOptions) {
        Validator.notNull(getBuildRunOptions, "getBuildRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getBuildRunOptions.projectId());
        pathParamsMap.put("name", getBuildRunOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/build_runs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getBuildRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BuildRun>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteBuildRun(DeleteBuildRunOptions deleteBuildRunOptions) {
        Validator.notNull(deleteBuildRunOptions, "deleteBuildRunOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteBuildRunOptions.projectId());
        pathParamsMap.put("name", deleteBuildRunOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/build_runs/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteBuildRun");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DomainMappingList> listDomainMappings(ListDomainMappingsOptions listDomainMappingsOptions) {
        Validator.notNull(listDomainMappingsOptions, "listDomainMappingsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listDomainMappingsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/domain_mappings", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listDomainMappings");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listDomainMappingsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listDomainMappingsOptions.limit()));
        }
        if (listDomainMappingsOptions.start() != null) {
            builder.query("start", String.valueOf(listDomainMappingsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DomainMappingList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DomainMapping> createDomainMapping(CreateDomainMappingOptions createDomainMappingOptions) {
        Validator.notNull(createDomainMappingOptions, "createDomainMappingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createDomainMappingOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/domain_mappings", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createDomainMapping");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("component", GsonSingleton.getGson().toJsonTree(createDomainMappingOptions.component()));
        contentJson.addProperty("name", createDomainMappingOptions.name());
        contentJson.addProperty("tls_secret", createDomainMappingOptions.tlsSecret());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DomainMapping>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DomainMapping> getDomainMapping(GetDomainMappingOptions getDomainMappingOptions) {
        Validator.notNull(getDomainMappingOptions, "getDomainMappingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getDomainMappingOptions.projectId());
        pathParamsMap.put("name", getDomainMappingOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/domain_mappings/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getDomainMapping");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DomainMapping>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteDomainMapping(DeleteDomainMappingOptions deleteDomainMappingOptions) {
        Validator.notNull(deleteDomainMappingOptions, "deleteDomainMappingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteDomainMappingOptions.projectId());
        pathParamsMap.put("name", deleteDomainMappingOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/domain_mappings/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteDomainMapping");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DomainMapping> updateDomainMapping(UpdateDomainMappingOptions updateDomainMappingOptions) {
        Validator.notNull(updateDomainMappingOptions, "updateDomainMappingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateDomainMappingOptions.projectId());
        pathParamsMap.put("name", updateDomainMappingOptions.name());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/domain_mappings/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updateDomainMapping");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", updateDomainMappingOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateDomainMappingOptions.domainMapping()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DomainMapping>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigMapList> listConfigMaps(ListConfigMapsOptions listConfigMapsOptions) {
        Validator.notNull(listConfigMapsOptions, "listConfigMapsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listConfigMapsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/config_maps", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listConfigMaps");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listConfigMapsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listConfigMapsOptions.limit()));
        }
        if (listConfigMapsOptions.start() != null) {
            builder.query("start", String.valueOf(listConfigMapsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ConfigMapList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigMap> createConfigMap(CreateConfigMapOptions createConfigMapOptions) {
        Validator.notNull(createConfigMapOptions, "createConfigMapOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createConfigMapOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/config_maps", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createConfigMap");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createConfigMapOptions.name());
        if (createConfigMapOptions.data() != null) {
            contentJson.add("data", GsonSingleton.getGson().toJsonTree(createConfigMapOptions.data()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ConfigMap>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigMap> getConfigMap(GetConfigMapOptions getConfigMapOptions) {
        Validator.notNull(getConfigMapOptions, "getConfigMapOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getConfigMapOptions.projectId());
        pathParamsMap.put("name", getConfigMapOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/config_maps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getConfigMap");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ConfigMap>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigMap> replaceConfigMap(ReplaceConfigMapOptions replaceConfigMapOptions) {
        Validator.notNull(replaceConfigMapOptions, "replaceConfigMapOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", replaceConfigMapOptions.projectId());
        pathParamsMap.put("name", replaceConfigMapOptions.name());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/config_maps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "replaceConfigMap");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", replaceConfigMapOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        if (replaceConfigMapOptions.data() != null) {
            contentJson.add("data", GsonSingleton.getGson().toJsonTree(replaceConfigMapOptions.data()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ConfigMap>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteConfigMap(DeleteConfigMapOptions deleteConfigMapOptions) {
        Validator.notNull(deleteConfigMapOptions, "deleteConfigMapOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteConfigMapOptions.projectId());
        pathParamsMap.put("name", deleteConfigMapOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/config_maps/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteConfigMap");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretList> listSecrets(ListSecretsOptions listSecretsOptions) {
        Validator.notNull(listSecretsOptions, "listSecretsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listSecretsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/secrets", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "listSecrets");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        if (listSecretsOptions.format() != null) {
            builder.query("format", String.valueOf(listSecretsOptions.format()));
        }
        if (listSecretsOptions.limit() != null) {
            builder.query("limit", String.valueOf(listSecretsOptions.limit()));
        }
        if (listSecretsOptions.start() != null) {
            builder.query("start", String.valueOf(listSecretsOptions.start()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SecretList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Secret> createSecret(CreateSecretOptions createSecretOptions) {
        Validator.notNull(createSecretOptions, "createSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createSecretOptions.projectId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/secrets", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createSecret");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("format", createSecretOptions.format());
        contentJson.addProperty("name", createSecretOptions.name());
        if (createSecretOptions.data() != null) {
            contentJson.add("data", GsonSingleton.getGson().toJsonTree(createSecretOptions.data()));
        }
        if (createSecretOptions.serviceAccess() != null) {
            contentJson.add("service_access", GsonSingleton.getGson().toJsonTree(createSecretOptions.serviceAccess()));
        }
        if (createSecretOptions.serviceOperator() != null) {
            contentJson.add("service_operator", GsonSingleton.getGson().toJsonTree(createSecretOptions.serviceOperator()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Secret> getSecret(GetSecretOptions getSecretOptions) {
        Validator.notNull(getSecretOptions, "getSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getSecretOptions.projectId());
        pathParamsMap.put("name", getSecretOptions.name());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/secrets/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getSecret");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Secret> replaceSecret(ReplaceSecretOptions replaceSecretOptions) {
        Validator.notNull(replaceSecretOptions, "replaceSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", replaceSecretOptions.projectId());
        pathParamsMap.put("name", replaceSecretOptions.name());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/secrets/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "replaceSecret");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("If-Match", replaceSecretOptions.ifMatch());
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("format", replaceSecretOptions.format());
        if (replaceSecretOptions.data() != null) {
            contentJson.add("data", GsonSingleton.getGson().toJsonTree(replaceSecretOptions.data()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSecret(DeleteSecretOptions deleteSecretOptions) {
        Validator.notNull(deleteSecretOptions, "deleteSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteSecretOptions.projectId());
        pathParamsMap.put("name", deleteSecretOptions.name());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/projects/{project_id}/secrets/{name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteSecret");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (this.version != null) {
            builder.query("version", String.valueOf(this.version));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

