/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.BuildParamPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateBuildRunOptions
extends GenericModel {
    protected String projectId;
    protected String buildName;
    protected String name;
    protected String outputImage;
    protected String outputSecret;
    protected List<BuildParamPrototype> runBuildParams;
    protected String serviceAccount;
    protected String sourceContextDir;
    protected String sourceRevision;
    protected String sourceSecret;
    protected String sourceType;
    protected String sourceUrl;
    protected String strategySize;
    protected String strategySpecFile;
    protected String strategyType;
    protected Long timeout;

    protected CreateBuildRunOptions() {
    }

    protected CreateBuildRunOptions(Builder builder) {
        Validator.notEmpty(builder.projectId, "projectId cannot be empty");
        this.projectId = builder.projectId;
        this.buildName = builder.buildName;
        this.name = builder.name;
        this.outputImage = builder.outputImage;
        this.outputSecret = builder.outputSecret;
        this.runBuildParams = builder.runBuildParams;
        this.serviceAccount = builder.serviceAccount;
        this.sourceContextDir = builder.sourceContextDir;
        this.sourceRevision = builder.sourceRevision;
        this.sourceSecret = builder.sourceSecret;
        this.sourceType = builder.sourceType;
        this.sourceUrl = builder.sourceUrl;
        this.strategySize = builder.strategySize;
        this.strategySpecFile = builder.strategySpecFile;
        this.strategyType = builder.strategyType;
        this.timeout = builder.timeout;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String buildName() {
        return this.buildName;
    }

    public String name() {
        return this.name;
    }

    public String outputImage() {
        return this.outputImage;
    }

    public String outputSecret() {
        return this.outputSecret;
    }

    public List<BuildParamPrototype> runBuildParams() {
        return this.runBuildParams;
    }

    public String serviceAccount() {
        return this.serviceAccount;
    }

    public String sourceContextDir() {
        return this.sourceContextDir;
    }

    public String sourceRevision() {
        return this.sourceRevision;
    }

    public String sourceSecret() {
        return this.sourceSecret;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String sourceUrl() {
        return this.sourceUrl;
    }

    public String strategySize() {
        return this.strategySize;
    }

    public String strategySpecFile() {
        return this.strategySpecFile;
    }

    public String strategyType() {
        return this.strategyType;
    }

    public Long timeout() {
        return this.timeout;
    }

    public static class Builder {
        private String projectId;
        private String buildName;
        private String name;
        private String outputImage;
        private String outputSecret;
        private List<BuildParamPrototype> runBuildParams;
        private String serviceAccount;
        private String sourceContextDir;
        private String sourceRevision;
        private String sourceSecret;
        private String sourceType;
        private String sourceUrl;
        private String strategySize;
        private String strategySpecFile;
        private String strategyType;
        private Long timeout;

        private Builder(CreateBuildRunOptions createBuildRunOptions) {
            this.projectId = createBuildRunOptions.projectId;
            this.buildName = createBuildRunOptions.buildName;
            this.name = createBuildRunOptions.name;
            this.outputImage = createBuildRunOptions.outputImage;
            this.outputSecret = createBuildRunOptions.outputSecret;
            this.runBuildParams = createBuildRunOptions.runBuildParams;
            this.serviceAccount = createBuildRunOptions.serviceAccount;
            this.sourceContextDir = createBuildRunOptions.sourceContextDir;
            this.sourceRevision = createBuildRunOptions.sourceRevision;
            this.sourceSecret = createBuildRunOptions.sourceSecret;
            this.sourceType = createBuildRunOptions.sourceType;
            this.sourceUrl = createBuildRunOptions.sourceUrl;
            this.strategySize = createBuildRunOptions.strategySize;
            this.strategySpecFile = createBuildRunOptions.strategySpecFile;
            this.strategyType = createBuildRunOptions.strategyType;
            this.timeout = createBuildRunOptions.timeout;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public CreateBuildRunOptions build() {
            return new CreateBuildRunOptions(this);
        }

        public Builder addRunBuildParams(BuildParamPrototype runBuildParams) {
            Validator.notNull(runBuildParams, "runBuildParams cannot be null");
            if (this.runBuildParams == null) {
                this.runBuildParams = new ArrayList<BuildParamPrototype>();
            }
            this.runBuildParams.add(runBuildParams);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder buildName(String buildName) {
            this.buildName = buildName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder outputImage(String outputImage) {
            this.outputImage = outputImage;
            return this;
        }

        public Builder outputSecret(String outputSecret) {
            this.outputSecret = outputSecret;
            return this;
        }

        public Builder runBuildParams(List<BuildParamPrototype> runBuildParams) {
            this.runBuildParams = runBuildParams;
            return this;
        }

        public Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public Builder sourceContextDir(String sourceContextDir) {
            this.sourceContextDir = sourceContextDir;
            return this;
        }

        public Builder sourceRevision(String sourceRevision) {
            this.sourceRevision = sourceRevision;
            return this;
        }

        public Builder sourceSecret(String sourceSecret) {
            this.sourceSecret = sourceSecret;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder strategySize(String strategySize) {
            this.strategySize = strategySize;
            return this;
        }

        public Builder strategySpecFile(String strategySpecFile) {
            this.strategySpecFile = strategySpecFile;
            return this;
        }

        public Builder strategyType(String strategyType) {
            this.strategyType = strategyType;
            return this;
        }

        public Builder timeout(long timeout2) {
            this.timeout = timeout2;
            return this;
        }
    }

    public static interface StrategyType {
        public static final String DOCKERFILE = "dockerfile";
        public static final String BUILDPACKS = "buildpacks";
    }

    public static interface StrategySize {
        public static final String SMALL = "small";
        public static final String MEDIUM = "medium";
        public static final String LARGE = "large";
        public static final String XLARGE = "xlarge";
        public static final String XXLARGE = "xxlarge";
    }

    public static interface SourceType {
        public static final String LOCAL = "local";
        public static final String GIT = "git";
    }

    public static interface ServiceAccount {
        public static final String X_DEFAULT = "default";
        public static final String MANAGER = "manager";
        public static final String READER = "reader";
        public static final String WRITER = "writer";
        public static final String NONE = "none";
    }
}

