/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.ComponentRef;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateDomainMappingOptions
extends GenericModel {
    protected String projectId;
    protected ComponentRef component;
    protected String name;
    protected String tlsSecret;

    protected CreateDomainMappingOptions() {
    }

    protected CreateDomainMappingOptions(Builder builder) {
        Validator.notEmpty(builder.projectId, "projectId cannot be empty");
        Validator.notNull(builder.component, "component cannot be null");
        Validator.notNull(builder.name, "name cannot be null");
        Validator.notNull(builder.tlsSecret, "tlsSecret cannot be null");
        this.projectId = builder.projectId;
        this.component = builder.component;
        this.name = builder.name;
        this.tlsSecret = builder.tlsSecret;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public ComponentRef component() {
        return this.component;
    }

    public String name() {
        return this.name;
    }

    public String tlsSecret() {
        return this.tlsSecret;
    }

    public static class Builder {
        private String projectId;
        private ComponentRef component;
        private String name;
        private String tlsSecret;

        private Builder(CreateDomainMappingOptions createDomainMappingOptions) {
            this.projectId = createDomainMappingOptions.projectId;
            this.component = createDomainMappingOptions.component;
            this.name = createDomainMappingOptions.name;
            this.tlsSecret = createDomainMappingOptions.tlsSecret;
        }

        public Builder() {
        }

        public Builder(String projectId, ComponentRef component, String name, String tlsSecret) {
            this.projectId = projectId;
            this.component = component;
            this.name = name;
            this.tlsSecret = tlsSecret;
        }

        public CreateDomainMappingOptions build() {
            return new CreateDomainMappingOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder component(ComponentRef component) {
            this.component = component;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tlsSecret(String tlsSecret) {
            this.tlsSecret = tlsSecret;
            return this;
        }
    }
}

