/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.EnvVarPrototype;
import com.ibm.cloud.code_engine.code_engine.v2.model.VolumeMountPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateJobRunOptions
extends GenericModel {
    protected String projectId;
    protected String imageReference;
    protected String imageSecret;
    protected String jobName;
    protected String name;
    protected List<String> runArguments;
    protected Long runAsUser;
    protected List<String> runCommands;
    protected Boolean runComputeResourceTokenEnabled;
    protected List<EnvVarPrototype> runEnvVariables;
    protected String runMode;
    protected String runServiceAccount;
    protected List<VolumeMountPrototype> runVolumeMounts;
    protected Long scaleArraySizeVariableOverride;
    protected String scaleArraySpec;
    protected String scaleCpuLimit;
    protected String scaleEphemeralStorageLimit;
    protected Long scaleMaxExecutionTime;
    protected String scaleMemoryLimit;
    protected Long scaleRetryLimit;

    protected CreateJobRunOptions() {
    }

    protected CreateJobRunOptions(Builder builder) {
        Validator.notEmpty(builder.projectId, "projectId cannot be empty");
        this.projectId = builder.projectId;
        this.imageReference = builder.imageReference;
        this.imageSecret = builder.imageSecret;
        this.jobName = builder.jobName;
        this.name = builder.name;
        this.runArguments = builder.runArguments;
        this.runAsUser = builder.runAsUser;
        this.runCommands = builder.runCommands;
        this.runComputeResourceTokenEnabled = builder.runComputeResourceTokenEnabled;
        this.runEnvVariables = builder.runEnvVariables;
        this.runMode = builder.runMode;
        this.runServiceAccount = builder.runServiceAccount;
        this.runVolumeMounts = builder.runVolumeMounts;
        this.scaleArraySizeVariableOverride = builder.scaleArraySizeVariableOverride;
        this.scaleArraySpec = builder.scaleArraySpec;
        this.scaleCpuLimit = builder.scaleCpuLimit;
        this.scaleEphemeralStorageLimit = builder.scaleEphemeralStorageLimit;
        this.scaleMaxExecutionTime = builder.scaleMaxExecutionTime;
        this.scaleMemoryLimit = builder.scaleMemoryLimit;
        this.scaleRetryLimit = builder.scaleRetryLimit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String imageReference() {
        return this.imageReference;
    }

    public String imageSecret() {
        return this.imageSecret;
    }

    public String jobName() {
        return this.jobName;
    }

    public String name() {
        return this.name;
    }

    public List<String> runArguments() {
        return this.runArguments;
    }

    public Long runAsUser() {
        return this.runAsUser;
    }

    public List<String> runCommands() {
        return this.runCommands;
    }

    public Boolean runComputeResourceTokenEnabled() {
        return this.runComputeResourceTokenEnabled;
    }

    public List<EnvVarPrototype> runEnvVariables() {
        return this.runEnvVariables;
    }

    public String runMode() {
        return this.runMode;
    }

    public String runServiceAccount() {
        return this.runServiceAccount;
    }

    public List<VolumeMountPrototype> runVolumeMounts() {
        return this.runVolumeMounts;
    }

    public Long scaleArraySizeVariableOverride() {
        return this.scaleArraySizeVariableOverride;
    }

    public String scaleArraySpec() {
        return this.scaleArraySpec;
    }

    public String scaleCpuLimit() {
        return this.scaleCpuLimit;
    }

    public String scaleEphemeralStorageLimit() {
        return this.scaleEphemeralStorageLimit;
    }

    public Long scaleMaxExecutionTime() {
        return this.scaleMaxExecutionTime;
    }

    public String scaleMemoryLimit() {
        return this.scaleMemoryLimit;
    }

    public Long scaleRetryLimit() {
        return this.scaleRetryLimit;
    }

    public static class Builder {
        private String projectId;
        private String imageReference;
        private String imageSecret;
        private String jobName;
        private String name;
        private List<String> runArguments;
        private Long runAsUser;
        private List<String> runCommands;
        private Boolean runComputeResourceTokenEnabled;
        private List<EnvVarPrototype> runEnvVariables;
        private String runMode;
        private String runServiceAccount;
        private List<VolumeMountPrototype> runVolumeMounts;
        private Long scaleArraySizeVariableOverride;
        private String scaleArraySpec;
        private String scaleCpuLimit;
        private String scaleEphemeralStorageLimit;
        private Long scaleMaxExecutionTime;
        private String scaleMemoryLimit;
        private Long scaleRetryLimit;

        private Builder(CreateJobRunOptions createJobRunOptions) {
            this.projectId = createJobRunOptions.projectId;
            this.imageReference = createJobRunOptions.imageReference;
            this.imageSecret = createJobRunOptions.imageSecret;
            this.jobName = createJobRunOptions.jobName;
            this.name = createJobRunOptions.name;
            this.runArguments = createJobRunOptions.runArguments;
            this.runAsUser = createJobRunOptions.runAsUser;
            this.runCommands = createJobRunOptions.runCommands;
            this.runComputeResourceTokenEnabled = createJobRunOptions.runComputeResourceTokenEnabled;
            this.runEnvVariables = createJobRunOptions.runEnvVariables;
            this.runMode = createJobRunOptions.runMode;
            this.runServiceAccount = createJobRunOptions.runServiceAccount;
            this.runVolumeMounts = createJobRunOptions.runVolumeMounts;
            this.scaleArraySizeVariableOverride = createJobRunOptions.scaleArraySizeVariableOverride;
            this.scaleArraySpec = createJobRunOptions.scaleArraySpec;
            this.scaleCpuLimit = createJobRunOptions.scaleCpuLimit;
            this.scaleEphemeralStorageLimit = createJobRunOptions.scaleEphemeralStorageLimit;
            this.scaleMaxExecutionTime = createJobRunOptions.scaleMaxExecutionTime;
            this.scaleMemoryLimit = createJobRunOptions.scaleMemoryLimit;
            this.scaleRetryLimit = createJobRunOptions.scaleRetryLimit;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public CreateJobRunOptions build() {
            return new CreateJobRunOptions(this);
        }

        public Builder addRunArguments(String runArguments) {
            Validator.notNull(runArguments, "runArguments cannot be null");
            if (this.runArguments == null) {
                this.runArguments = new ArrayList<String>();
            }
            this.runArguments.add(runArguments);
            return this;
        }

        public Builder addRunCommands(String runCommands) {
            Validator.notNull(runCommands, "runCommands cannot be null");
            if (this.runCommands == null) {
                this.runCommands = new ArrayList<String>();
            }
            this.runCommands.add(runCommands);
            return this;
        }

        public Builder addRunEnvVariables(EnvVarPrototype runEnvVariables) {
            Validator.notNull(runEnvVariables, "runEnvVariables cannot be null");
            if (this.runEnvVariables == null) {
                this.runEnvVariables = new ArrayList<EnvVarPrototype>();
            }
            this.runEnvVariables.add(runEnvVariables);
            return this;
        }

        public Builder addRunVolumeMounts(VolumeMountPrototype runVolumeMounts) {
            Validator.notNull(runVolumeMounts, "runVolumeMounts cannot be null");
            if (this.runVolumeMounts == null) {
                this.runVolumeMounts = new ArrayList<VolumeMountPrototype>();
            }
            this.runVolumeMounts.add(runVolumeMounts);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder imageReference(String imageReference) {
            this.imageReference = imageReference;
            return this;
        }

        public Builder imageSecret(String imageSecret) {
            this.imageSecret = imageSecret;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder runArguments(List<String> runArguments) {
            this.runArguments = runArguments;
            return this;
        }

        public Builder runAsUser(long runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public Builder runCommands(List<String> runCommands) {
            this.runCommands = runCommands;
            return this;
        }

        public Builder runComputeResourceTokenEnabled(Boolean runComputeResourceTokenEnabled) {
            this.runComputeResourceTokenEnabled = runComputeResourceTokenEnabled;
            return this;
        }

        public Builder runEnvVariables(List<EnvVarPrototype> runEnvVariables) {
            this.runEnvVariables = runEnvVariables;
            return this;
        }

        public Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        public Builder runServiceAccount(String runServiceAccount) {
            this.runServiceAccount = runServiceAccount;
            return this;
        }

        public Builder runVolumeMounts(List<VolumeMountPrototype> runVolumeMounts) {
            this.runVolumeMounts = runVolumeMounts;
            return this;
        }

        public Builder scaleArraySizeVariableOverride(long scaleArraySizeVariableOverride) {
            this.scaleArraySizeVariableOverride = scaleArraySizeVariableOverride;
            return this;
        }

        public Builder scaleArraySpec(String scaleArraySpec) {
            this.scaleArraySpec = scaleArraySpec;
            return this;
        }

        public Builder scaleCpuLimit(String scaleCpuLimit) {
            this.scaleCpuLimit = scaleCpuLimit;
            return this;
        }

        public Builder scaleEphemeralStorageLimit(String scaleEphemeralStorageLimit) {
            this.scaleEphemeralStorageLimit = scaleEphemeralStorageLimit;
            return this;
        }

        public Builder scaleMaxExecutionTime(long scaleMaxExecutionTime) {
            this.scaleMaxExecutionTime = scaleMaxExecutionTime;
            return this;
        }

        public Builder scaleMemoryLimit(String scaleMemoryLimit) {
            this.scaleMemoryLimit = scaleMemoryLimit;
            return this;
        }

        public Builder scaleRetryLimit(long scaleRetryLimit) {
            this.scaleRetryLimit = scaleRetryLimit;
            return this;
        }
    }

    public static interface RunServiceAccount {
        public static final String X_DEFAULT = "default";
        public static final String MANAGER = "manager";
        public static final String READER = "reader";
        public static final String WRITER = "writer";
        public static final String NONE = "none";
    }

    public static interface RunMode {
        public static final String TASK = "task";
        public static final String DAEMON = "daemon";
    }
}

