/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.Cp4dToken;
import com.ibm.cloud.sdk.core.security.Cp4dTokenResponse;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class CloudPakForDataAuthenticator
extends TokenRequestBasedAuthenticator<Cp4dToken, Cp4dTokenResponse>
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(CloudPakForDataAuthenticator.class.getName());
    private String url;
    private String username;
    private String password;
    private String apikey;

    protected CloudPakForDataAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("cp4d-authenticator"));
    }

    protected CloudPakForDataAuthenticator(Builder builder) {
        this();
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.apikey = builder.apikey;
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public CloudPakForDataAuthenticator(String url, String username, String password) {
        this();
        this.init(url, username, password, false, null);
    }

    @Deprecated
    public CloudPakForDataAuthenticator(String url, String username, String password, boolean disableSSLVerification, Map<String, String> headers) {
        this();
        this.init(url, username, password, disableSSLVerification, headers);
    }

    @Deprecated
    public CloudPakForDataAuthenticator(Map<String, String> config) {
        this();
        this.apikey = config.get("APIKEY");
        this.init(config.get("AUTH_URL"), config.get("USERNAME"), config.get("PASSWORD"), Boolean.valueOf(config.get("AUTH_DISABLE_SSL")), null);
    }

    public static CloudPakForDataAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().url(config.get("AUTH_URL")).username(config.get("USERNAME")).password(config.get("PASSWORD")).apikey(config.get("APIKEY")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    protected void init(String url, String username, String password, boolean disableSSLVerification, Map<String, String> headers) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.setDisableSSLVerification(disableSSLVerification);
        this.setHeaders(headers);
        this.validate();
    }

    @Override
    public String authenticationType() {
        return "cp4d";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty(this.url)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "url"));
        }
        if (StringUtils.isEmpty(this.username)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (StringUtils.isEmpty(this.password) && StringUtils.isEmpty(this.apikey) || StringUtils.isNotEmpty(this.password) && StringUtils.isNotEmpty(this.apikey)) {
            throw new IllegalArgumentException(String.format("Exactly one of %s or %s must be specified.", "password", "apikey"));
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getApikey() {
        return this.apikey;
    }

    @Override
    public Cp4dToken requestToken() {
        Cp4dToken token;
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.url, "/v1/authorize"));
        builder.header("Content-Type", "application/json");
        builder.header("User-Agent", this.getUserAgent());
        CP4DRequestBody requestBody = new CP4DRequestBody(this.username, this.password, this.apikey);
        builder.bodyContent("application/json", (Object)requestBody, null, (InputStream)null);
        try {
            LOG.log(Level.FINE, "Invoking CP4D token service operation: POST {0}", builder.toUrl());
            Cp4dTokenResponse response = this.invokeRequest(builder, Cp4dTokenResponse.class);
            LOG.log(Level.FINE, "Returned from CP4D token service operation");
            token = new Cp4dToken(response);
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Exception from CP4D token service operation: ", t);
            token = new Cp4dToken(t);
        }
        return token;
    }

    private static class CP4DRequestBody {
        private String username;
        private String password;
        @SerializedName(value="api_key")
        private String apikey;

        CP4DRequestBody(String username, String password, String apikey) {
            this.username = username;
            this.password = password;
            this.apikey = apikey;
        }
    }

    public static class Builder {
        private String url;
        private String username;
        private String password;
        private String apikey;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(CloudPakForDataAuthenticator obj) {
            this.url = obj.url;
            this.username = obj.username;
            this.password = obj.password;
            this.apikey = obj.apikey;
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public CloudPakForDataAuthenticator build() {
            return new CloudPakForDataAuthenticator(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

